/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/schemas")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class SchemasResource {
    private static final Logger log = LoggerFactory.getLogger(SchemasResource.class);
    private final KafkaSchemaRegistry schemaRegistry;

    public SchemasResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @GET
    @Operation(summary="List schemas", description="Get the schemas matching the specified parameters.", responses={@ApiResponse(responseCode="200", description="The schemas matching the specified parameters", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class)))}), @ApiResponse(responseCode="500", description="Error code 50001 -- Error in the backend data store\n")})
    @PerformanceMetric(value="schemas.get-schemas")
    public List<io.confluent.kafka.schemaregistry.client.rest.entities.Schema> getSchemas(@Parameter(description="Filters results by the respective subject prefix") @DefaultValue(value="") @QueryParam(value="subjectPrefix") String subjectPrefix, @Parameter(description="Whether to return soft deleted schemas") @DefaultValue(value="false") @QueryParam(value="deleted") boolean lookupDeletedSchema, @Parameter(description="Whether to return latest schema versions only for each matching subject") @DefaultValue(value="false") @QueryParam(value="latestOnly") boolean latestOnly, @Parameter(description="Pagination offset for results") @DefaultValue(value="0") @QueryParam(value="offset") int offset, @Parameter(description="Pagination size for results. Ignored if negative") @DefaultValue(value="-1") @QueryParam(value="limit") int limit) {
        Iterator<io.confluent.kafka.schemaregistry.client.rest.entities.Schema> schemas;
        ArrayList<io.confluent.kafka.schemaregistry.client.rest.entities.Schema> filteredSchemas = new ArrayList<io.confluent.kafka.schemaregistry.client.rest.entities.Schema>();
        String errorMessage = "Error while getting schemas for prefix " + subjectPrefix;
        try {
            schemas = this.schemaRegistry.getVersionsWithSubjectPrefix(subjectPrefix, lookupDeletedSchema, latestOnly);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        int fromIndex = offset;
        int toIndex = limit > 0 ? offset + limit : Integer.MAX_VALUE;
        for (int index = 0; schemas.hasNext() && index < toIndex; ++index) {
            io.confluent.kafka.schemaregistry.client.rest.entities.Schema schema = schemas.next();
            if (index < offset) continue;
            filteredSchemas.add(schema);
        }
        return filteredSchemas;
    }

    @GET
    @Path(value="/ids/{id}")
    @Operation(summary="Get schema string by ID", description="Retrieves the schema string identified by the input ID.", responses={@ApiResponse(responseCode="200", description="The schema string", content={@Content(schema=@Schema(implementation=SchemaString.class))}), @ApiResponse(responseCode="404", description="Error code 40403 -- Schema not found\n"), @ApiResponse(responseCode="500", description="Error code 50001 -- Error in the backend data store\n")})
    @PerformanceMetric(value="schemas.ids.get-schema")
    public SchemaString getSchema(@Parameter(description="Globally unique identifier of the schema", required=true) @PathParam(value="id") Integer id, @Parameter(description="Name of the subject") @QueryParam(value="subject") String subject, @Parameter(description="Desired output format, dependent on schema type") @DefaultValue(value="") @QueryParam(value="format") String format, @Parameter(description="Whether to fetch the maximum schema identifier that exists") @DefaultValue(value="false") @QueryParam(value="fetchMaxId") boolean fetchMaxId) {
        SchemaString schema;
        String errorMessage = "Error while retrieving schema with id " + id + " from the schema registry";
        try {
            schema = this.schemaRegistry.get(id, subject, format, fetchMaxId);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (schema == null) {
            throw Errors.schemaNotFoundException(id);
        }
        return schema;
    }

    @GET
    @Path(value="/ids/{id}/subjects")
    @Operation(summary="List subjects associated to schema ID", description="Retrieves all the subjects associated with a particular schema ID.", responses={@ApiResponse(responseCode="200", description="The subjects matching the specified parameters", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class)))}), @ApiResponse(responseCode="404", description="Error code 40403 -- Schema not found\n"), @ApiResponse(responseCode="500", description="Error code 50001 -- Error in the backend data store\n")})
    public Set<String> getSubjects(@Parameter(description="Globally unique identifier of the schema", required=true) @PathParam(value="id") Integer id, @Parameter(description="Filters results by the respective subject") @QueryParam(value="subject") String subject, @Parameter(description="Whether to include subjects where the schema was deleted") @QueryParam(value="deleted") boolean lookupDeletedSchema) {
        Set<String> subjects;
        String errorMessage = "Error while retrieving all subjects associated with schema id " + id + " from the schema registry";
        try {
            subjects = this.schemaRegistry.listSubjectsForId(id, subject, lookupDeletedSchema);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (subjects == null) {
            throw Errors.schemaNotFoundException();
        }
        return subjects;
    }

    @GET
    @Path(value="/ids/{id}/versions")
    @Operation(summary="List subject-versions associated to schema ID", description="Get all the subject-version pairs associated with the input ID.", responses={@ApiResponse(responseCode="200", description="The subject versions matching the specified parameters", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SubjectVersion.class)))}), @ApiResponse(responseCode="404", description="Error code 40403 -- Schema not found\n"), @ApiResponse(responseCode="500", description="Error code 50001 -- Error in the backend data store\n")})
    public List<SubjectVersion> getVersions(@Parameter(description="Globally unique identifier of the schema", required=true) @PathParam(value="id") Integer id, @Parameter(description="Filters results by the respective subject") @QueryParam(value="subject") String subject, @Parameter(description="Whether to include subject versions where the schema was deleted") @QueryParam(value="deleted") boolean lookupDeletedSchema) {
        List<SubjectVersion> versions;
        String errorMessage = "Error while retrieving all subjects associated with schema id " + id + " from the schema registry";
        try {
            versions = this.schemaRegistry.listVersionsForId(id, subject, lookupDeletedSchema);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (versions == null) {
            throw Errors.schemaNotFoundException();
        }
        return versions;
    }

    @GET
    @Path(value="/types")
    @Operation(summary="List supported schema types", description="Retrieve the schema types supported by this registry.", responses={@ApiResponse(responseCode="200", description="The supported schema types", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class)))}), @ApiResponse(responseCode="500", description="Error code 50001 -- Error in the backend data store\n")})
    public Set<String> getSchemaTypes() {
        return this.schemaRegistry.schemaTypes();
    }
}

