/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.storage.CloseableIterator;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.ConfigValue;
import io.confluent.kafka.schemaregistry.storage.LookupCache;
import io.confluent.kafka.schemaregistry.storage.MD5;
import io.confluent.kafka.schemaregistry.storage.Mode;
import io.confluent.kafka.schemaregistry.storage.ModeKey;
import io.confluent.kafka.schemaregistry.storage.ModeValue;
import io.confluent.kafka.schemaregistry.storage.SchemaIdAndSubjects;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaReference;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.SubjectKeyComparator;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import io.confluent.kafka.schemaregistry.storage.serialization.Serializer;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InMemoryCache<K, V>
implements LookupCache<K, V> {
    private final ConcurrentNavigableMap<K, V> store = new ConcurrentSkipListMap(new SubjectKeyComparator(this));
    private final Map<String, Map<String, Map<Integer, Map<String, Integer>>>> guidToSubjectVersions = new ConcurrentHashMap<String, Map<String, Map<Integer, Map<String, Integer>>>>();
    private final Map<String, Map<String, Map<MD5, Integer>>> hashToGuid = new ConcurrentHashMap<String, Map<String, Map<MD5, Integer>>>();
    private final Map<String, Map<String, Map<SchemaKey, Set<Integer>>>> referencedBy = new ConcurrentHashMap<String, Map<String, Map<SchemaKey, Set<Integer>>>>();

    public InMemoryCache(Serializer<K, V> serializer) {
    }

    @Override
    public void init() throws StoreInitializationException {
    }

    @Override
    public V get(K key) throws StoreException {
        return this.store.get(key);
    }

    @Override
    public V put(K key, V value) throws StoreException {
        return this.store.put(key, value);
    }

    @Override
    public CloseableIterator<V> getAll(K key1, K key2) throws StoreException {
        SortedMap<K, V> subMap = key1 == null && key2 == null ? this.store : this.store.subMap((Object)key1, (Object)key2);
        return new DelegatingIterator(subMap.values().iterator());
    }

    @Override
    public void putAll(Map<K, V> entries) throws StoreException {
        this.store.putAll(entries);
    }

    @Override
    public V delete(K key) throws StoreException {
        return this.store.remove(key);
    }

    @Override
    public CloseableIterator<K> getAllKeys() throws StoreException {
        return new DelegatingIterator(this.store.keySet().iterator());
    }

    @Override
    public void flush() throws StoreException {
    }

    @Override
    public void close() throws StoreException {
        this.store.clear();
    }

    @Override
    public SchemaIdAndSubjects schemaIdAndSubjects(Schema schema) throws StoreException {
        String ctx = QualifiedSubject.contextFor((String)this.tenant(), (String)schema.getSubject());
        List refs = schema.getReferences();
        MD5 md5 = MD5.ofString(schema.getSchema(), refs == null ? null : refs.stream().map(ref -> new SchemaReference(ref.getName(), ref.getSubject(), ref.getVersion())).collect(Collectors.toList()));
        Map ctxHashes = this.hashToGuid.getOrDefault(this.tenant(), Collections.emptyMap());
        Map hashes = ctxHashes.getOrDefault(ctx, Collections.emptyMap());
        Integer id = (Integer)hashes.get(md5);
        if (id == null) {
            return null;
        }
        Map ctxGuids = this.guidToSubjectVersions.getOrDefault(this.tenant(), Collections.emptyMap());
        Map guids = ctxGuids.getOrDefault(ctx, Collections.emptyMap());
        Map subjectVersions = (Map)guids.get(id);
        if (subjectVersions == null || subjectVersions.isEmpty()) {
            return null;
        }
        return new SchemaIdAndSubjects(id, subjectVersions);
    }

    @Override
    public boolean containsSchema(Schema schema) throws StoreException {
        return this.schemaIdAndSubjects(schema) != null;
    }

    @Override
    public Set<Integer> referencesSchema(SchemaKey schema) throws StoreException {
        String ctx = QualifiedSubject.contextFor((String)this.tenant(), (String)schema.getSubject());
        Map ctxRefBy = this.referencedBy.getOrDefault(this.tenant(), Collections.emptyMap());
        Map refBy = ctxRefBy.getOrDefault(ctx, Collections.emptyMap());
        return refBy.getOrDefault(schema, Collections.emptySet());
    }

    @Override
    public SchemaKey schemaKeyById(Integer id, String subject) throws StoreException {
        String ctx = QualifiedSubject.contextFor((String)this.tenant(), (String)subject);
        Map ctxGuids = this.guidToSubjectVersions.getOrDefault(this.tenant(), Collections.emptyMap());
        Map guids = ctxGuids.getOrDefault(ctx, Collections.emptyMap());
        Map subjectVersions = (Map)guids.get(id);
        if (subjectVersions == null || subjectVersions.isEmpty()) {
            return null;
        }
        Map.Entry entry = subjectVersions.entrySet().iterator().next();
        return new SchemaKey((String)entry.getKey(), (Integer)entry.getValue());
    }

    @Override
    public void schemaDeleted(SchemaKey schemaKey, SchemaValue schemaValue, SchemaValue oldSchemaValue) {
        String ctx = QualifiedSubject.contextFor((String)this.tenant(), (String)schemaKey.getSubject());
        Map ctxGuids = this.guidToSubjectVersions.computeIfAbsent(this.tenant(), k -> new ConcurrentHashMap());
        Map guids = ctxGuids.computeIfAbsent(ctx, k -> new ConcurrentHashMap());
        Map subjectVersions = guids.computeIfAbsent(schemaValue.getId(), k -> new ConcurrentHashMap());
        subjectVersions.put(schemaKey.getSubject(), schemaKey.getVersion());
        this.addToSchemaHashToGuid(schemaKey, schemaValue);
        for (SchemaReference ref : schemaValue.getReferences()) {
            Set ids;
            SchemaKey refKey = new SchemaKey(ref.getSubject(), ref.getVersion());
            Map ctxRefBy = this.referencedBy.getOrDefault(this.tenant(), Collections.emptyMap());
            Map refBy = ctxRefBy.getOrDefault(ctx, Collections.emptyMap());
            if (refBy == null || (ids = (Set)refBy.get(refKey)) == null) continue;
            ids.remove(schemaValue.getId());
            if (!ids.isEmpty()) continue;
            refBy.remove(refKey);
        }
    }

    @Override
    public void schemaTombstoned(SchemaKey schemaKey, SchemaValue schemaValue) {
        if (schemaValue == null) {
            return;
        }
        String ctx = QualifiedSubject.contextFor((String)this.tenant(), (String)schemaKey.getSubject());
        Map ctxGuids = this.guidToSubjectVersions.getOrDefault(this.tenant(), Collections.emptyMap());
        Map guids = ctxGuids.getOrDefault(ctx, Collections.emptyMap());
        Map subjectVersions = (Map)guids.get(schemaValue.getId());
        if (subjectVersions == null || subjectVersions.isEmpty()) {
            return;
        }
        subjectVersions.computeIfPresent(schemaKey.getSubject(), (k, v) -> schemaKey.getVersion() == v.intValue() ? null : v);
        if (subjectVersions.isEmpty()) {
            guids.remove(schemaValue.getId());
        }
    }

    @Override
    public void schemaRegistered(SchemaKey schemaKey, SchemaValue schemaValue, SchemaValue oldSchemaValue) {
        String ctx = QualifiedSubject.contextFor((String)this.tenant(), (String)schemaKey.getSubject());
        Map ctxGuids = this.guidToSubjectVersions.computeIfAbsent(this.tenant(), k -> new ConcurrentHashMap());
        Map guids = ctxGuids.computeIfAbsent(ctx, k -> new ConcurrentHashMap());
        Map subjectVersions = guids.computeIfAbsent(schemaValue.getId(), k -> new ConcurrentHashMap());
        subjectVersions.put(schemaKey.getSubject(), schemaKey.getVersion());
        this.addToSchemaHashToGuid(schemaKey, schemaValue);
        for (SchemaReference ref : schemaValue.getReferences()) {
            SchemaKey refKey = new SchemaKey(ref.getSubject(), ref.getVersion());
            Map ctxRefBy = this.referencedBy.computeIfAbsent(this.tenant(), k -> new ConcurrentHashMap());
            Map refBy = ctxRefBy.computeIfAbsent(ctx, k -> new ConcurrentHashMap());
            Set ids = refBy.computeIfAbsent(refKey, k -> Collections.newSetFromMap(new ConcurrentHashMap()));
            ids.add(schemaValue.getId());
        }
    }

    private void addToSchemaHashToGuid(SchemaKey schemaKey, SchemaValue schemaValue) {
        String ctx = QualifiedSubject.contextFor((String)this.tenant(), (String)schemaKey.getSubject());
        MD5 md5 = MD5.ofString(schemaValue.getSchema(), schemaValue.getReferences());
        Map ctxHashes = this.hashToGuid.computeIfAbsent(this.tenant(), k -> new ConcurrentHashMap());
        Map hashes = ctxHashes.computeIfAbsent(ctx, k -> new ConcurrentHashMap());
        hashes.put(md5, schemaValue.getId());
    }

    @Override
    public CompatibilityLevel compatibilityLevel(String subject, boolean returnTopLevelIfNotFound, CompatibilityLevel defaultForTopLevel) throws StoreException {
        ConfigKey subjectConfigKey = new ConfigKey(subject);
        ConfigValue config = (ConfigValue)this.get(subjectConfigKey);
        if (config == null && subject == null) {
            return defaultForTopLevel;
        }
        if (config != null) {
            return config.getCompatibilityLevel();
        }
        if (returnTopLevelIfNotFound) {
            QualifiedSubject qs = QualifiedSubject.create((String)this.tenant(), (String)subject);
            config = qs != null && !".".equals(qs.getContext()) ? (ConfigValue)this.get(new ConfigKey(qs.toQualifiedContext())) : (ConfigValue)this.get(new ConfigKey(null));
            return config != null ? config.getCompatibilityLevel() : defaultForTopLevel;
        }
        return null;
    }

    @Override
    public Mode mode(String subject, boolean returnTopLevelIfNotFound, Mode defaultForTopLevel) throws StoreException {
        ModeKey modeKey = new ModeKey(subject);
        ModeValue modeValue = (ModeValue)this.get(modeKey);
        if (modeValue == null && subject == null) {
            return defaultForTopLevel;
        }
        if (modeValue != null) {
            return modeValue.getMode();
        }
        if (returnTopLevelIfNotFound) {
            QualifiedSubject qs = QualifiedSubject.create((String)this.tenant(), (String)subject);
            modeValue = qs != null && !".".equals(qs.getContext()) ? (ModeValue)this.get(new ModeKey(qs.toQualifiedContext())) : (ModeValue)this.get(new ModeKey(null));
            return modeValue != null ? modeValue.getMode() : defaultForTopLevel;
        }
        return null;
    }

    @Override
    public Set<String> subjects(String subject, boolean lookupDeletedSubjects) throws StoreException {
        return this.subjects(this.matchingSubjectPredicate(subject), lookupDeletedSubjects);
    }

    private Set<String> subjects(Predicate<String> match, boolean lookupDeletedSubjects) {
        return this.store.entrySet().stream().flatMap(e -> {
            Object k = e.getKey();
            Object v = e.getValue();
            if (k instanceof SchemaKey) {
                SchemaKey key = (SchemaKey)k;
                SchemaValue value = (SchemaValue)v;
                if (value != null && (!value.isDeleted() || lookupDeletedSubjects)) {
                    return match.test(key.getSubject()) ? Stream.of(key.getSubject()) : Stream.empty();
                }
            }
            return Stream.empty();
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public boolean hasSubjects(String subject, boolean lookupDeletedSubjects) throws StoreException {
        return this.hasSubjects(this.matchingSubjectPredicate(subject), lookupDeletedSubjects);
    }

    private boolean hasSubjects(Predicate<String> match, boolean lookupDeletedSubjects) {
        return this.store.entrySet().stream().anyMatch(e -> {
            Object k = e.getKey();
            Object v = e.getValue();
            if (k instanceof SchemaKey) {
                SchemaKey key = (SchemaKey)k;
                SchemaValue value = (SchemaValue)v;
                if (value != null && (!value.isDeleted() || lookupDeletedSubjects)) {
                    return match.test(key.getSubject());
                }
            }
            return false;
        });
    }

    @Override
    public Map<String, Integer> clearSubjects(String subject) throws StoreException {
        return this.clearSubjects(subject, this.matchingSubjectPredicate(subject));
    }

    private Map<String, Integer> clearSubjects(String subject, Predicate<String> match) {
        String ctx = QualifiedSubject.contextFor((String)this.tenant(), (String)subject);
        BiPredicate<String, Integer> matchDeleted = this.matchDeleted(match);
        Map ctxGuids = this.guidToSubjectVersions.getOrDefault(this.tenant(), Collections.emptyMap());
        Map guids = ctxGuids.getOrDefault(ctx, Collections.emptyMap());
        Iterator it = guids.entrySet().iterator();
        while (it.hasNext()) {
            Map subjectVersions = (Map)it.next().getValue();
            subjectVersions.entrySet().removeIf(e -> matchDeleted.test((String)e.getKey(), (Integer)e.getValue()));
            if (!subjectVersions.isEmpty()) continue;
            it.remove();
        }
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        this.store.entrySet().removeIf(e -> {
            if (e.getKey() instanceof SchemaKey) {
                boolean isMatch;
                SchemaKey key = (SchemaKey)e.getKey();
                SchemaValue value = (SchemaValue)e.getValue();
                boolean bl = isMatch = match.test(key.getSubject()) && value.isDeleted();
                if (isMatch) {
                    String schemaType = value.getSchemaType();
                    if (schemaType == null) {
                        schemaType = "AVRO";
                    }
                    counts.merge(schemaType, 1, Integer::sum);
                }
                return isMatch;
            }
            return false;
        });
        return counts;
    }

    protected Predicate<String> matchingSubjectPredicate(String subject) {
        return s -> subject == null || subject.equals(s);
    }

    private BiPredicate<String, Integer> matchDeleted(Predicate<String> match) {
        return (subject, version) -> {
            if (match.test((String)subject)) {
                SchemaValue value = (SchemaValue)this.store.get(new SchemaKey((String)subject, (int)version));
                return value == null || value.isDeleted();
            }
            return false;
        };
    }

    static class DelegatingIterator<T>
    implements CloseableIterator<T> {
        private final Iterator<T> iterator;

        public DelegatingIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void close() {
        }
    }
}

