/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.hibernate.validator.constraints.NotEmpty;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaReference
implements Comparable<SchemaReference> {
    @NotEmpty
    private String name;
    @NotEmpty
    private String subject;
    private Integer version;

    @JsonCreator
    public SchemaReference(@JsonProperty(value="name") String name, @JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version) {
        this.name = name;
        this.subject = subject;
        this.version = version;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaReference that = (SchemaReference)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.subject, that.subject) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.subject, this.version);
    }

    @Override
    public int compareTo(SchemaReference that) {
        int result = this.subject.compareTo(that.subject);
        if (result != 0) {
            return result;
        }
        result = this.version - that.version;
        return result;
    }

    public String toString() {
        return "{name='" + this.name + '\'' + ", subject='" + this.subject + '\'' + ", version=" + this.version + '}';
    }
}

