/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.protobuf;

import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.schemaregistry.utils.ResourceLoader;
import io.confluent.kafka.serializers.protobuf.test.Root;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class RestApiTest
extends ClusterTestHarness {
    private static final Random random = new Random();

    public RestApiTest() {
        super(1, true);
    }

    @Override
    protected Properties getSchemaRegistryProperties() {
        Properties props = new Properties();
        props.setProperty("schema.providers", ProtobufSchemaProvider.class.getName());
        return props;
    }

    @Test
    public void testBasic() throws Exception {
        int i;
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        int schemasInSubject1 = 10;
        ArrayList<Integer> allVersionsInSubject1 = new ArrayList<Integer>();
        List<String> allSchemasInSubject1 = RestApiTest.getRandomProtobufSchemas(schemasInSubject1);
        int schemasInSubject2 = 5;
        ArrayList<Integer> allVersionsInSubject2 = new ArrayList<Integer>();
        List<String> allSchemasInSubject2 = RestApiTest.getRandomProtobufSchemas(schemasInSubject2);
        ArrayList<String> allSubjects = new ArrayList<String>();
        Assert.assertEquals((String)"Getting all subjects should return empty", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
        int schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject1; ++i) {
            String schema = allSchemasInSubject1.get(i);
            int expectedVersion = i + 1;
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject1);
            ++schemaIdCounter;
            allVersionsInSubject1.add(expectedVersion);
        }
        allSubjects.add(subject1);
        for (i = 0; i < schemasInSubject1; ++i) {
            int expectedId = i + 1;
            String schemaString = allSchemasInSubject1.get(i);
            int foundId = this.restApp.restClient.registerSchema(schemaString, "PROTOBUF", Collections.emptyList(), subject1);
            Assert.assertEquals((String)"Re-registering an existing schema should return the existing version", (long)expectedId, (long)foundId);
        }
        for (i = 0; i < schemasInSubject2; ++i) {
            String schema = allSchemasInSubject2.get(i);
            int expectedVersion = i + 1;
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject2);
            ++schemaIdCounter;
            allVersionsInSubject2.add(expectedVersion);
        }
        allSubjects.add(subject2);
        Assert.assertEquals((String)"Getting all versions from subject1 should match all registered versions", allVersionsInSubject1, (Object)this.restApp.restClient.getAllVersions(subject1));
        Assert.assertEquals((String)"Getting all versions from subject2 should match all registered versions", allVersionsInSubject2, (Object)this.restApp.restClient.getAllVersions(subject2));
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
    }

    @Test
    public void testSchemaReferences() throws Exception {
        Map<String, String> schemas = RestApiTest.getProtobufSchemaWithDependencies();
        String subject = "confluent/meta.proto";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, schemas.get("confluent/meta.proto"), 1, subject);
        subject = "reference";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, schemas.get("ref.proto"), 2, subject);
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get("root.proto"));
        request.setSchemaType("PROTOBUF");
        SchemaReference ref = new SchemaReference("ref.proto", "reference", Integer.valueOf(1));
        SchemaReference meta = new SchemaReference("confluent/meta.proto", "confluent/meta.proto", Integer.valueOf(1));
        List<SchemaReference> refs = Arrays.asList(ref, meta);
        request.setReferences(refs);
        int registeredId = this.restApp.restClient.registerSchema(request, "referrer", false);
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)3L, (long)registeredId);
        SchemaString schemaString = this.restApp.restClient.getId(3);
        Assert.assertEquals((String)"Registered schema should be found", (Object)schemas.get("root.proto"), (Object)schemaString.getSchemaString());
        Assert.assertEquals((String)"Schema dependencies should be found", refs, (Object)schemaString.getReferences());
        Root.ReferrerMessage referrer = Root.ReferrerMessage.newBuilder().build();
        ProtobufSchema schema = ProtobufSchemaUtils.getSchema((Message)referrer);
        schema = schema.copy(refs);
        Schema registeredSchema = this.restApp.restClient.lookUpSubjectVersion(schema.canonicalString(), "PROTOBUF", schema.references(), "referrer", false);
        Assert.assertEquals((String)"Registered schema should be found", (long)3L, (long)registeredSchema.getId().intValue());
    }

    @Test
    public void testSchemaReferencesPkg() throws Exception {
        String msg1 = "syntax = \"proto3\";\npackage pkg1;\n\noption go_package = \"pkg1pb\";\noption java_multiple_files = true;\noption java_outer_classname = \"Msg1Proto\";\noption java_package = \"com.pkg1\";\n\nmessage Message1 {\n  string s = 1;\n}\n";
        String subject = "pkg1/msg1.proto";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, msg1, 1, subject);
        subject = "pkg2/msg2.proto";
        String msg2 = "syntax = \"proto3\";\npackage pkg2;\n\noption go_package = \"pkg2pb\";\noption java_multiple_files = true;\noption java_outer_classname = \"Msg2Proto\";\noption java_package = \"com.pkg2\";\n\nimport \"pkg1/msg1.proto\";\n\nmessage Message2 {\n  map<string, pkg1.Message1> map = 1;\n  pkg1.Message1 f2 = 2;\n}\n";
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(msg2);
        request.setSchemaType("PROTOBUF");
        SchemaReference meta = new SchemaReference("pkg1/msg1.proto", "pkg1/msg1.proto", Integer.valueOf(1));
        List<SchemaReference> refs = Arrays.asList(meta);
        request.setReferences(refs);
        int registeredId = this.restApp.restClient.registerSchema(request, subject, false);
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)2L, (long)registeredId);
    }

    @Test(expected=RestClientException.class)
    public void testSchemaMissingReferences() throws Exception {
        Map<String, String> schemas = RestApiTest.getProtobufSchemaWithDependencies();
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get("root.proto"));
        request.setSchemaType("PROTOBUF");
        request.setReferences(Collections.emptyList());
        this.restApp.restClient.registerSchema(request, "referrer", false);
    }

    @Test
    public void testSchemaNormalization() throws Exception {
        String subject1 = "testSubject1";
        String msg1 = "syntax = \"proto3\";\npackage pkg1;\n\noption go_package = \"pkg1pb\";\noption java_multiple_files = true;\noption java_outer_classname = \"Msg1Proto\";\noption java_package = \"com.pkg1\";\n\nmessage Message1 {\n  string s = 1;\n}\n";
        String subject = "pkg1/msg1.proto";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, msg1, 1, subject);
        String msg2 = "syntax = \"proto3\";\npackage pkg2;\n\noption go_package = \"pkg2pb\";\noption java_multiple_files = true;\noption java_outer_classname = \"Msg2Proto\";\noption java_package = \"com.pkg2\";\n\nmessage Message2 {\n  string s = 1;\n}\n";
        subject = "pkg2/msg2.proto";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, msg2, 2, subject);
        String msg3 = "syntax = \"proto3\";\npackage pkg3;\n\noption go_package = \"pkg3pb\";\noption java_multiple_files = true;\noption java_outer_classname = \"Msg3Proto\";\noption java_package = \"com.pkg3\";\n\nimport \"pkg1/msg1.proto\";\nimport \"pkg2/msg2.proto\";\n\nmessage Message3 {\n  map<string, pkg1.Message1> map = 1;\n  pkg1.Message1 f1 = 2;\n  pkg2.Message2 f2 = 3;\n}\n";
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(msg3);
        request.setSchemaType("PROTOBUF");
        SchemaReference ref1 = new SchemaReference("pkg1/msg1.proto", "pkg1/msg1.proto", Integer.valueOf(1));
        SchemaReference ref2 = new SchemaReference("pkg2/msg2.proto", "pkg2/msg2.proto", Integer.valueOf(1));
        List<SchemaReference> refs = Arrays.asList(ref1, ref2);
        request.setReferences(refs);
        int registeredId = this.restApp.restClient.registerSchema(request, subject1, true);
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)3L, (long)registeredId);
        msg3 = "syntax = \"proto3\";\npackage pkg3;\n\noption java_package = \"com.pkg3\";\noption java_outer_classname = \"Msg3Proto\";\noption java_multiple_files = true;\noption go_package = \"pkg3pb\";\n\nimport \"pkg2/msg2.proto\";\nimport \"pkg1/msg1.proto\";\n\nmessage Message3 {\n  pkg2.Message2 f2 = 3;\n  pkg1.Message1 f1 = 2;\n  map<string, pkg1.Message1> map = 1;\n}\n";
        RegisterSchemaRequest lookUpRequest = new RegisterSchemaRequest();
        lookUpRequest.setSchema(msg3);
        lookUpRequest.setSchemaType("PROTOBUF");
        lookUpRequest.setReferences(Arrays.asList(ref2, ref1));
        int versionOfRegisteredSchema1Subject1 = this.restApp.restClient.lookUpSubjectVersion(lookUpRequest, subject1, true, false).getVersion();
        Assert.assertEquals((String)"1st schema under subject1 should have version 1", (long)1L, (long)versionOfRegisteredSchema1Subject1);
        Assert.assertEquals((String)"1st schema registered globally should have id 3", (long)3L, (long)registeredId);
    }

    @Test
    public void testBad() throws Exception {
        String subject1 = "testTopic1";
        ArrayList allSubjects = new ArrayList();
        Assert.assertEquals((String)"Getting all subjects should return empty", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
        try {
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, RestApiTest.getBadSchema(), 1, subject1);
            Assert.fail((String)"Registering bad schema should fail with 42201");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
        try {
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, RestApiTest.getRandomProtobufSchemas(1).get(0), Arrays.asList(new SchemaReference("bad", "bad", Integer.valueOf(100))), 1, subject1);
            Assert.fail((String)"Registering bad reference should fail with 42201");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
    }

    @Test
    public void testCustomOption() throws Exception {
        String subject = "test-proto";
        String enumOptionSchemaString = "syntax = \"proto3\";\n\nimport \"google/protobuf/descriptor.proto\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestEnumProtos\";\noption php_namespace = \"Bug\\\\V1\";\n\nmessage TestEnum {\n  option (some_ref) = \"https://test.com\";\n\n  Suit suit = 1;\n\n  oneof test_oneof {\n    option (some_ref) = \"https://test.com\";\n  \n    string name = 2;\n    int32 age = 3;\n  }\n\n  enum Suit {\n    option (some_ref) = \"https://test.com\";\n    SPADES = 0;\n    HEARTS = 1;\n    DIAMONDS = 2;\n    CLUBS = 3;\n  }\n}\n";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, enumOptionSchemaString, 1, subject);
    }

    public static void registerAndVerifySchema(RestService restService, String schemaString, int expectedId, String subject) throws IOException, RestClientException {
        RestApiTest.registerAndVerifySchema(restService, schemaString, Collections.emptyList(), expectedId, subject);
    }

    public static void registerAndVerifySchema(RestService restService, String schemaString, List<SchemaReference> references, int expectedId, String subject) throws IOException, RestClientException {
        int registeredId = restService.registerSchema(schemaString, "PROTOBUF", references, subject);
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)expectedId, (long)registeredId);
        Assert.assertEquals((String)"Registered schema should be found", (Object)schemaString.trim(), (Object)restService.getId(expectedId).getSchemaString().trim());
    }

    public static List<String> getRandomProtobufSchemas(int num) {
        ArrayList<String> schemas = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            String schema = "syntax = \"proto3\";\npackage io.confluent.kafka.serializers.protobuf.test;\n\nmessage MyMessage {\n  string f" + random.nextInt(Integer.MAX_VALUE) + " = 1;\n  bool is_active = 2;\n}\n";
            schemas.add(schema);
        }
        return schemas;
    }

    public static Map<String, String> getProtobufSchemaWithDependencies() {
        HashMap<String, String> schemas = new HashMap<String, String>();
        String meta = ResourceLoader.DEFAULT.toString("confluent/meta.proto");
        schemas.put("confluent/meta.proto", meta);
        String reference = "syntax = \"proto3\";\npackage io.confluent.kafka.serializers.protobuf.test;\n\nmessage ReferencedMessage {\n  string ref_id = 1;\n  bool is_active = 2;\n}\n";
        schemas.put("ref.proto", reference);
        String schemaString = "syntax = \"proto3\";\npackage io.confluent.kafka.serializers.protobuf.test;\n\nimport \"ref.proto\";\nimport \"confluent/meta.proto\";\n\nmessage ReferrerMessage {\n  option (confluent.message_meta) = {\n    doc: \"ReferrerMessage\"\n  };\n\n  string root_id = 1;\n  .io.confluent.kafka.serializers.protobuf.test.ReferencedMessage ref = 2 [(confluent.field_meta) = {\n    doc: \"ReferencedMessage\"\n  }];\n}\n";
        schemas.put("root.proto", schemaString);
        return schemas;
    }

    public static String getBadSchema() {
        String schema = "syntax = \"proto3\";\npackage io.confluent.kafka.serializers.protobuf.test;\n\nbad-message MyMessage {\n  string f" + random.nextInt(Integer.MAX_VALUE) + " = 1;\n  bool is_active = 2;\n}\n";
        return schema;
    }
}

