/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.client.SchemaVersionFetcher;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.LookupFilter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface SchemaRegistry
extends SchemaVersionFetcher {
    public static final String DEFAULT_TENANT = "default";

    public void init() throws SchemaRegistryException;

    public Set<String> schemaTypes();

    default public int register(String subject, Schema schema) throws SchemaRegistryException {
        return this.register(subject, schema, false);
    }

    public int register(String var1, Schema var2, boolean var3) throws SchemaRegistryException;

    default public Schema getByVersion(String subject, int version, boolean returnDeletedSchema) {
        try {
            return this.get(subject, version, returnDeletedSchema);
        }
        catch (SchemaRegistryException e) {
            throw new RuntimeException(e);
        }
    }

    public Schema get(String var1, int var2, boolean var3) throws SchemaRegistryException;

    public SchemaString get(int var1, String var2) throws SchemaRegistryException;

    default public Set<String> listSubjects() throws SchemaRegistryException {
        return this.listSubjects(LookupFilter.DEFAULT);
    }

    public Set<String> listSubjects(LookupFilter var1) throws SchemaRegistryException;

    public Set<String> listSubjectsForId(int var1, String var2, boolean var3) throws SchemaRegistryException;

    public Iterator<Schema> getAllVersions(String var1, LookupFilter var2) throws SchemaRegistryException;

    public Iterator<Schema> getVersionsWithSubjectPrefix(String var1, LookupFilter var2, boolean var3) throws SchemaRegistryException;

    public Schema getLatestVersion(String var1) throws SchemaRegistryException;

    public List<Integer> deleteSubject(String var1, boolean var2) throws SchemaRegistryException;

    default public Schema lookUpSchemaUnderSubject(String subject, Schema schema, boolean lookupDeletedSchema) throws SchemaRegistryException {
        return this.lookUpSchemaUnderSubject(subject, schema, false, lookupDeletedSchema);
    }

    public Schema lookUpSchemaUnderSubject(String var1, Schema var2, boolean var3, boolean var4) throws SchemaRegistryException;

    public List<String> isCompatible(String var1, Schema var2, Schema var3) throws SchemaRegistryException;

    public List<String> isCompatible(String var1, Schema var2, List<Schema> var3) throws SchemaRegistryException;

    public void close();

    public void deleteSchemaVersion(String var1, Schema var2, boolean var3) throws SchemaRegistryException;

    default public String tenant() {
        return DEFAULT_TENANT;
    }

    default public void setTenant(String tenant) {
    }

    public SchemaRegistryConfig config();

    public Map<String, Object> properties();
}

