/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaEntity;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTags;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.TagSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.RuleSetHandler;
import io.confluent.kafka.schemaregistry.utils.TestUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RestApiRegisterSchemaTagsTest
extends ClusterTestHarness {
    public final String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}";

    public RestApiRegisterSchemaTagsTest() {
        super(1, true);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ((KafkaSchemaRegistry)this.restApp.schemaRegistry()).setRuleSetHandler(new RuleSetHandler(){

            public void handle(String subject, ConfigUpdateRequest request) {
            }

            public void handle(String subject, boolean normalize, RegisterSchemaRequest request) {
            }

            public void handle(String subject, TagSchemaRequest request) {
            }

            public io.confluent.kafka.schemaregistry.storage.RuleSet transform(RuleSet ruleSet) {
                return ruleSet != null ? new io.confluent.kafka.schemaregistry.storage.RuleSet(ruleSet) : null;
            }
        });
    }

    @Test
    public void testRegisterSchemaTagsBasic() throws Exception {
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}", 1, subject);
        TagSchemaRequest tagSchemaRequest = new TagSchemaRequest();
        tagSchemaRequest.setNewVersion(Integer.valueOf(2));
        tagSchemaRequest.setTagsToAdd(Collections.singletonList(new SchemaTags(new SchemaEntity("myrecord", SchemaEntity.EntityType.SR_RECORD), Arrays.asList("TAG1", "TAG2"))));
        String expectedSchema = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}],\"confluent:tags\":[\"TAG1\",\"TAG2\"]}";
        RegisterSchemaResponse responses = this.restApp.restClient.modifySchemaTags(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, "latest");
        Assert.assertEquals((long)2L, (long)responses.getId());
        Schema result = this.restApp.restClient.getLatestVersion(subject);
        Assert.assertEquals((Object)expectedSchema, (Object)result.getSchema());
        Assert.assertEquals((Object)2, (Object)result.getVersion());
        Assert.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        tagSchemaRequest = new TagSchemaRequest();
        tagSchemaRequest.setNewVersion(Integer.valueOf(3));
        tagSchemaRequest.setTagsToRemove(Collections.singletonList(new SchemaTags(new SchemaEntity("myrecord", SchemaEntity.EntityType.SR_RECORD), Arrays.asList("TAG2"))));
        expectedSchema = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}],\"confluent:tags\":[\"TAG1\"]}";
        responses = this.restApp.restClient.modifySchemaTags(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, "latest");
        Assert.assertEquals((long)3L, (long)responses.getId());
        result = this.restApp.restClient.getLatestVersion(subject);
        Assert.assertEquals((Object)expectedSchema, (Object)result.getSchema());
        Assert.assertEquals((Object)3, (Object)result.getVersion());
        Assert.assertEquals((Object)"3", result.getMetadata().getProperties().get("confluent:version"));
    }

    @Test
    public void testRegisterSchemaWithoutNewVersionInput() throws Exception {
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}", 1, subject);
        TagSchemaRequest tagSchemaRequest = new TagSchemaRequest();
        tagSchemaRequest.setTagsToAdd(Collections.singletonList(new SchemaTags(new SchemaEntity("myrecord", SchemaEntity.EntityType.SR_RECORD), Arrays.asList("TAG1", "TAG2"))));
        String expectedSchema = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}],\"confluent:tags\":[\"TAG1\",\"TAG2\"]}";
        RegisterSchemaResponse responses = this.restApp.restClient.modifySchemaTags(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, "latest");
        Assert.assertEquals((long)2L, (long)responses.getId());
        Schema result = this.restApp.restClient.getLatestVersion(subject);
        Assert.assertEquals((Object)expectedSchema, (Object)result.getSchema());
        Assert.assertEquals((Object)2, (Object)result.getVersion());
        Assert.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        tagSchemaRequest = new TagSchemaRequest();
        tagSchemaRequest.setTagsToRemove(Collections.singletonList(new SchemaTags(new SchemaEntity("myrecord", SchemaEntity.EntityType.SR_RECORD), Arrays.asList("TAG2"))));
        expectedSchema = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}],\"confluent:tags\":[\"TAG1\"]}";
        responses = this.restApp.restClient.modifySchemaTags(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, "latest");
        Assert.assertEquals((long)3L, (long)responses.getId());
        result = this.restApp.restClient.getLatestVersion(subject);
        Assert.assertEquals((Object)expectedSchema, (Object)result.getSchema());
        Assert.assertEquals((Object)3, (Object)result.getVersion());
        Assert.assertEquals((Object)"3", result.getMetadata().getProperties().get("confluent:version"));
    }

    @Test
    public void testRegisterSchemaTagsInDiffContext() throws Exception {
        String subject = ":.ctx:testSubject";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}", 1, subject);
        TagSchemaRequest tagSchemaRequest = new TagSchemaRequest();
        tagSchemaRequest.setNewVersion(Integer.valueOf(2));
        tagSchemaRequest.setTagsToAdd(Collections.singletonList(new SchemaTags(new SchemaEntity("myrecord", SchemaEntity.EntityType.SR_RECORD), Arrays.asList("TAG1", "TAG2"))));
        String expectedSchema = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}],\"confluent:tags\":[\"TAG1\",\"TAG2\"]}";
        RegisterSchemaResponse responses = this.restApp.restClient.modifySchemaTags(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, "latest");
        Assert.assertEquals((long)2L, (long)responses.getId());
        Schema result = this.restApp.restClient.getLatestVersion(subject);
        Assert.assertEquals((Object)expectedSchema, (Object)result.getSchema());
        Assert.assertEquals((Object)2, (Object)result.getVersion());
        Assert.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
    }

    @Test
    public void testRegisterSchemaTagsWithInvalidSchema() throws Exception {
        RegisterSchemaResponse e3;
        TagSchemaRequest tagSchemaRequest = new TagSchemaRequest();
        tagSchemaRequest.setNewVersion(Integer.valueOf(2));
        tagSchemaRequest.setTagsToAdd(Collections.singletonList(new SchemaTags(new SchemaEntity("myrecord", SchemaEntity.EntityType.SR_RECORD), Collections.singletonList("TAG1"))));
        try {
            RegisterSchemaResponse registerSchemaResponse = this.restApp.restClient.modifySchemaTags(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, "non-exist", "1");
        }
        catch (RestClientException e2) {
            Assert.assertEquals((long)40401L, (long)e2.getErrorCode());
        }
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}", 1, subject);
        try {
            RegisterSchemaResponse registerSchemaResponse = this.restApp.restClient.modifySchemaTags(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, "2");
        }
        catch (RestClientException e3) {
            Assert.assertEquals((long)40402L, (long)e3.getErrorCode());
        }
        try {
            e3 = this.restApp.restClient.modifySchemaTags(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, "-1");
        }
        catch (RestClientException e4) {
            Assert.assertEquals((long)42201L, (long)e4.getErrorCode());
        }
        tagSchemaRequest.setNewVersion(Integer.valueOf(1));
        try {
            e3 = this.restApp.restClient.modifySchemaTags(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, "1");
        }
        catch (RestClientException e5) {
            Assert.assertEquals((long)42201L, (long)e5.getErrorCode());
        }
    }

    @Test
    public void testRegisterSchemaTagsWithInvalidTags() throws Exception {
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}", 1, subject);
        TagSchemaRequest tagSchemaRequest = new TagSchemaRequest();
        tagSchemaRequest.setNewVersion(Integer.valueOf(2));
        tagSchemaRequest.setTagsToAdd(Collections.singletonList(new SchemaTags(new SchemaEntity("does.not.exist", SchemaEntity.EntityType.SR_FIELD), Collections.singletonList("TAG1"))));
        try {
            RegisterSchemaResponse registerSchemaResponse = this.restApp.restClient.modifySchemaTags(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, "1");
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)42201L, (long)e.getErrorCode());
        }
    }

    @Test
    public void testRegisterSchemaTagsIncrementalRuleSet() throws Exception {
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}", 1, subject);
        TagSchemaRequest tagSchemaRequest = new TagSchemaRequest();
        tagSchemaRequest.setNewVersion(Integer.valueOf(2));
        Rule migrationRule = new Rule("myMigrationRule", null, null, RuleMode.UPGRADE, "fooType", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, "NONE,NONE", false);
        Rule migrationRule2 = new Rule("myMigrationRule2", null, null, RuleMode.UPGRADE, "fooType", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, "NONE,NONE", false);
        Rule domainRule = new Rule("myRule", null, null, null, "fooType", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, "NONE,NONE", false);
        Rule domainRule2 = new Rule("myRule2", null, null, null, "fooType", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, "NONE,NONE", false);
        Rule domainRule3 = new Rule("myRule3", null, null, null, "fooType", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, "NONE,NONE", false);
        RuleSet ruleSet = new RuleSet((List)ImmutableList.of((Object)migrationRule, (Object)migrationRule2), (List)ImmutableList.of((Object)domainRule, (Object)domainRule2, (Object)domainRule3));
        tagSchemaRequest.setRulesToMerge(ruleSet);
        tagSchemaRequest.setRulesToRemove((List)ImmutableList.of((Object)"myRule4"));
        RegisterSchemaResponse responses = this.restApp.restClient.modifySchemaTags(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, "latest");
        Assert.assertEquals((long)2L, (long)responses.getId());
        Assert.assertEquals((Object)ruleSet, (Object)responses.getRuleSet());
        Schema result = this.restApp.restClient.getLatestVersion(subject);
        Assert.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        Assert.assertEquals((Object)ruleSet, (Object)responses.getRuleSet());
        tagSchemaRequest = new TagSchemaRequest();
        tagSchemaRequest.setNewVersion(Integer.valueOf(3));
        Rule migrationRule3 = new Rule("myMigrationRule3", null, null, RuleMode.UPGRADE, "fooType", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII2")), null, null, null, "NONE,NONE", false);
        Rule domainRule5 = new Rule("myRule5", null, null, null, "fooType", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII2")), null, null, null, "NONE,NONE", false);
        Rule domainRule4 = new Rule("myRule4", null, null, null, "fooType", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII2")), null, null, null, "NONE,NONE", false);
        domainRule2 = new Rule("myRule2", null, null, null, "fooType", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII2")), null, null, null, "NONE,NONE", false);
        ruleSet = new RuleSet((List)ImmutableList.of((Object)migrationRule3), (List)ImmutableList.of((Object)domainRule5, (Object)domainRule4, (Object)domainRule2));
        tagSchemaRequest.setRulesToMerge(ruleSet);
        tagSchemaRequest.setRulesToRemove((List)ImmutableList.of((Object)"myRule", (Object)"myMigrationRule2"));
        RuleSet expectedRuleSet = new RuleSet((List)ImmutableList.of((Object)migrationRule, (Object)migrationRule3), (List)ImmutableList.of((Object)domainRule3, (Object)domainRule5, (Object)domainRule4, (Object)domainRule2));
        responses = this.restApp.restClient.modifySchemaTags(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, "latest");
        Assert.assertEquals((long)3L, (long)responses.getId());
        Assert.assertEquals((Object)expectedRuleSet, (Object)responses.getRuleSet());
        result = this.restApp.restClient.getLatestVersion(subject);
        Assert.assertEquals((Object)3, (Object)result.getVersion());
        Assert.assertEquals((Object)"3", result.getMetadata().getProperties().get("confluent:version"));
        Assert.assertEquals((Object)expectedRuleSet, (Object)responses.getRuleSet());
    }
}

