/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class RestApiSchemaTooLargeTest
extends ClusterTestHarness {
    private static final String schema = "{\"namespace\": \"namespace\",\n \"type\": \"record\",\n \"name\": \"test\",\n \"fields\": [\n     {\"name\": \"null\", \"type\": \"null\"},\n     {\"name\": \"boolean\", \"type\": \"boolean\"},\n     {\"name\": \"int\", \"type\": \"int\"},\n     {\"name\": \"long\", \"type\": \"long\"},\n     {\"name\": \"float\", \"type\": \"float\"},\n     {\"name\": \"double\", \"type\": \"double\"},\n     {\"name\": \"bytes\", \"type\": \"bytes\"},\n     {\"name\": \"string\", \"type\": \"string\", \"aliases\": [\"string_alias\"]},\n     {\"name\": \"null_default\", \"type\": \"null\", \"default\": null},\n     {\"name\": \"boolean_default\", \"type\": \"boolean\", \"default\": false},\n     {\"name\": \"int_default\", \"type\": \"int\", \"default\": 24},\n     {\"name\": \"long_default\", \"type\": \"long\", \"default\": 4000000000},\n     {\"name\": \"float_default\", \"type\": \"float\", \"default\": 12.3},\n     {\"name\": \"double_default\", \"type\": \"double\", \"default\": 23.2},\n     {\"name\": \"bytes_default\", \"type\": \"bytes\", \"default\": \"bytes\"},\n     {\"name\": \"string_default\", \"type\": \"string\", \"default\": \"default string\"}\n]\n}";

    public RestApiSchemaTooLargeTest() {
        super(1, true);
    }

    @Test
    public void testSchemaTooLarge() throws Exception {
        String subject = "testTopic1";
        try {
            this.restApp.restClient.registerSchema(schema, subject);
            Assert.fail((String)"Registering a schema should return 40401");
        }
        catch (RestClientException e) {
            Assert.assertEquals((long)422L, (long)e.getStatus());
            Assert.assertEquals((long)42209L, (long)e.getErrorCode());
        }
    }

    @Override
    protected void injectProperties(Properties props) {
        super.injectProperties(props);
        props.setProperty("message.max.bytes", "600");
    }
}

