/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import io.confluent.rest.NamedURI;
import io.confluent.rest.RestConfigException;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class KafkaSchemaRegistryTest {
    @Test
    public void testGetPortForIdentityPrecedence() throws SchemaRegistryException, RestConfigException {
        String listeners = "http://localhost:456";
        Properties props = new Properties();
        props.setProperty("port", "123");
        props.setProperty("listeners", listeners);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        NamedURI listener = KafkaSchemaRegistry.getInterInstanceListener((List)config.getListeners(), (String)"", (String)"http");
        Assert.assertEquals((String)"Expected listeners to take precedence over port.", (long)456L, (long)listener.getUri().getPort());
        Assert.assertEquals((String)"Expected Scheme match", (Object)"http", (Object)listener.getUri().getScheme());
    }

    @Test
    public void testGetPortForIdentityNoListeners() throws SchemaRegistryException, RestConfigException {
        String listeners = "";
        Properties props = new Properties();
        props.setProperty("port", "123");
        props.setProperty("listeners", listeners);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        NamedURI listener = KafkaSchemaRegistry.getInterInstanceListener((List)config.getListeners(), (String)"", (String)"http");
        Assert.assertEquals((String)"Expected port to take the configured port value", (long)123L, (long)listener.getUri().getPort());
        Assert.assertEquals((String)"Expected Scheme match", (Object)"http", (Object)listener.getUri().getScheme());
    }

    @Test
    public void testGetPortForIdentityMultipleListenersWithHttps() throws SchemaRegistryException, RestConfigException {
        String listeners = "http://localhost:123, https://localhost:456";
        Properties props = new Properties();
        props.setProperty("port", "-1");
        props.setProperty("listeners", listeners);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        NamedURI listener = KafkaSchemaRegistry.getInterInstanceListener((List)config.getListeners(), (String)"", (String)"https");
        Assert.assertEquals((String)"Expected HTTPS listener's port to be returned", (long)456L, (long)listener.getUri().getPort());
        Assert.assertEquals((String)"Expected Scheme match", (Object)"https", (Object)listener.getUri().getScheme());
    }

    @Test
    public void testGetPortForIdentityMultipleListeners() throws SchemaRegistryException, RestConfigException {
        String listeners = "http://localhost:123, http://localhost:456";
        Properties props = new Properties();
        props.setProperty("port", "-1");
        props.setProperty("listeners", listeners);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        NamedURI listener = KafkaSchemaRegistry.getInterInstanceListener((List)config.getListeners(), (String)"", (String)"http");
        Assert.assertEquals((String)"Expected last listener's port to be returned", (long)456L, (long)listener.getUri().getPort());
        Assert.assertEquals((String)"Expected Scheme match", (Object)"http", (Object)listener.getUri().getScheme());
    }

    @Test
    public void testGetNamedInternalListener() throws SchemaRegistryException, RestConfigException {
        String listeners = "bob://localhost:123, http://localhost:456";
        String listenerProtocolMap = "bob:http";
        Properties props = new Properties();
        props.setProperty("port", "-1");
        props.setProperty("listeners", listeners);
        props.setProperty("listener.protocol.map", listenerProtocolMap);
        props.setProperty("inter.instance.listener.name", "bob");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        NamedURI listener = KafkaSchemaRegistry.getInterInstanceListener((List)config.getListeners(), (String)config.interInstanceListenerName(), (String)"http");
        Assert.assertEquals((String)"Expected internal listener's port to be returned", (long)123L, (long)listener.getUri().getPort());
        Assert.assertEquals((String)"Expected internal listener's name to be returned", (Object)"bob", (Object)listener.getName());
        Assert.assertEquals((String)"Expected Scheme match", (Object)"http", (Object)listener.getUri().getScheme());
    }

    @Test
    public void testMyIdentityWithoutPortOverride() throws RestConfigException, SchemaRegistryException {
        String listeners = "bob://localhost:123, http://localhost:456";
        String listenerProtocolMap = "bob:https";
        Properties props = new Properties();
        props.setProperty("host.name", "schema.registry-0.example.com");
        props.setProperty("listeners", listeners);
        props.setProperty("listener.protocol.map", listenerProtocolMap);
        props.setProperty("inter.instance.listener.name", "bob");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        SchemaRegistryIdentity schemaRegistryIdentity = new SchemaRegistryIdentity("schema.registry-0.example.com", Integer.valueOf(123), Boolean.valueOf(true), "https");
        NamedURI internalListener = KafkaSchemaRegistry.getInterInstanceListener((List)config.getListeners(), (String)config.interInstanceListenerName(), (String)"http");
        Assert.assertEquals((Object)schemaRegistryIdentity, (Object)KafkaSchemaRegistry.getMyIdentity((NamedURI)internalListener, (boolean)true, (SchemaRegistryConfig)config));
    }

    @Test
    public void testMyIdentityWithPortOverride() throws RestConfigException, SchemaRegistryException {
        String listeners = "bob://localhost:123, http://localhost:456";
        String listenerProtocolMap = "bob:https";
        Properties props = new Properties();
        props.setProperty("host.name", "schema.registry-0.example.com");
        props.setProperty("host.port", "443");
        props.setProperty("listeners", listeners);
        props.setProperty("listener.protocol.map", listenerProtocolMap);
        props.setProperty("inter.instance.listener.name", "bob");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        SchemaRegistryIdentity schemaRegistryIdentity = new SchemaRegistryIdentity("schema.registry-0.example.com", Integer.valueOf(443), Boolean.valueOf(true), "https");
        NamedURI internalListener = KafkaSchemaRegistry.getInterInstanceListener((List)config.getListeners(), (String)config.interInstanceListenerName(), (String)"http");
        Assert.assertEquals((Object)schemaRegistryIdentity, (Object)KafkaSchemaRegistry.getMyIdentity((NamedURI)internalListener, (boolean)true, (SchemaRegistryConfig)config));
    }
}

