/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.tools;

import io.confluent.common.utils.PerformanceStats;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.tools.SchemaRegistryPerformance;
import java.io.IOException;

public class SchemaRegistryClientPerformance
extends SchemaRegistryPerformance {
    CachedSchemaRegistryClient client;

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("Usage: java " + SchemaRegistryClientPerformance.class.getName() + " schema_registry_url subject num_schemas target_schemas_per_sec schema_type");
            System.exit(1);
        }
        String baseUrl = args[0];
        String subject = args[1];
        int numSchemas = Integer.parseInt(args[2]);
        int targetSchemasPerSec = Integer.parseInt(args[3]);
        String schemaType = args[4];
        SchemaRegistryClientPerformance perf = new SchemaRegistryClientPerformance(baseUrl, subject, numSchemas, targetSchemasPerSec, schemaType);
        perf.init();
        perf.run(targetSchemasPerSec);
        perf.close();
    }

    public SchemaRegistryClientPerformance(String baseUrl, String subject, long numSchemas, long targetSchemasPerSec, String schemaType) {
        super(baseUrl, subject, numSchemas, targetSchemasPerSec, schemaType);
        this.client = new CachedSchemaRegistryClient(this.restService, Integer.MAX_VALUE);
    }

    @Override
    protected void init() throws Exception {
        this.client.updateCompatibility(null, CompatibilityLevel.NONE.name);
    }

    @Override
    protected void doIteration(PerformanceStats.Callback cb) {
        ParsedSchema parsedSchema = SchemaRegistryClientPerformance.makeParsedSchema(this.schemaType, this.registeredSchemas);
        try {
            this.client.register(this.subject, parsedSchema);
            this.client.getId(this.subject, parsedSchema);
            this.client.getVersion(this.subject, parsedSchema);
            ++this.successfullyRegisteredSchemas;
        }
        catch (IOException e) {
            System.out.println("Problem registering schema: " + e.getMessage());
        }
        catch (RestClientException e) {
            System.out.println("Problem registering schema: " + e.getMessage());
        }
        ++this.registeredSchemas;
        cb.onCompletion(1, 0L);
    }

    @Override
    protected void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
        super.close();
    }
}

