/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SchemaRegistryExtensionTest
extends ClusterTestHarness {
    private static final String SUBJECT = "testSubject";

    public SchemaRegistryExtensionTest() {
        super(1, true, CompatibilityLevel.BACKWARD.name);
    }

    @Test
    public void testAllowResource() throws Exception {
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(schemaString1, SUBJECT), (String)"Registering should succeed");
    }

    @Test
    public void tesRejectResource() throws Exception {
        try {
            this.restApp.restClient.getLatestVersion(SUBJECT);
            Assertions.fail((String)"Getting all versions from non-existing subject1 should fail with 401");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)401, (int)rce.getStatus(), (String)"Should get a 401 status for GET operations");
        }
    }

    @Test
    public void testExtensionAddedHandler() throws Exception {
        KafkaSchemaRegistry kafkaSchemaRegistry = (KafkaSchemaRegistry)this.restApp.schemaRegistry();
        Assert.assertEquals((long)kafkaSchemaRegistry.getCustomHandler().size(), (long)1L);
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        this.restApp.restClient.registerSchema(schemaString1, SUBJECT);
        Assert.assertEquals((long)kafkaSchemaRegistry.getCustomHandler().size(), (long)2L);
    }

    @Override
    protected Properties getSchemaRegistryProperties() {
        Properties props = new Properties();
        props.put("resource.extension.class", TestSchemaRegistryExtension.class.getName() + "," + TestSchemaRegistryHandlerExtension.class.getName());
        return props;
    }

    public static class TestSchemaRegistryExtension
    implements SchemaRegistryResourceExtension {
        public void register(Configurable<?> config, SchemaRegistryConfig schemaRegistryConfig, SchemaRegistry schemaRegistry) {
            config.register((Object)new ContainerRequestFilter(){

                public void filter(ContainerRequestContext requestContext) throws IOException {
                    if (!requestContext.getMethod().equalsIgnoreCase("POST")) {
                        requestContext.abortWith(jakarta.ws.rs.core.Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"User cannot access the resource.").build());
                    }
                }
            });
        }

        public void close() {
        }
    }

    public static class TestSchemaRegistryHandlerExtension
    implements SchemaRegistryResourceExtension {
        public void register(Configurable<?> config, SchemaRegistryConfig schemaRegistryConfig, SchemaRegistry schemaRegistry) {
            final KafkaSchemaRegistry kafkaSchemaRegistry = (KafkaSchemaRegistry)schemaRegistry;
            kafkaSchemaRegistry.addCustomHandler((Handler.Singleton)new Handler.Wrapper(){

                public boolean handle(Request request, Response response, Callback callback) throws Exception {
                    kafkaSchemaRegistry.addCustomHandler((Handler.Singleton)new Handler.Wrapper());
                    super.handle(request, response, callback);
                    return true;
                }
            });
        }

        public void close() {
        }
    }
}

