/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.SSLClusterTestHarness;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.StoreUtils;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStoreSSLAuthTest
extends SSLClusterTestHarness {
    private static final Logger log = LoggerFactory.getLogger(KafkaStoreSSLAuthTest.class);

    @Test
    public void testInitialization() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitSSLKafkaStoreInstance(this.brokerList, this.clientSslConfigs, this.requireSSLClientAuth());
        kafkaStore.close();
    }

    @Test
    public void testInitializationWithoutClientAuth() throws Exception {
        Assertions.assertThrows(StoreInitializationException.class, () -> {
            KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitSSLKafkaStoreInstance(this.brokerList, this.clientSslConfigs, false);
            kafkaStore.close();
        });
    }

    @Test
    public void testDoubleInitialization() throws Exception {
        Assertions.assertThrows(StoreInitializationException.class, () -> {
            try (KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitSSLKafkaStoreInstance(this.brokerList, this.clientSslConfigs, this.requireSSLClientAuth());){
                kafkaStore.init();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimplePut() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitSSLKafkaStoreInstance(this.brokerList, this.clientSslConfigs, this.requireSSLClientAuth());
        String key = "Kafka";
        String value = "Rocks";
        try {
            kafkaStore.put((Object)key, (Object)value);
            String retrievedValue = (String)kafkaStore.get((Object)key);
            Assertions.assertEquals((Object)value, (Object)retrievedValue, (String)"Retrieved value should match entered value");
        }
        finally {
            kafkaStore.close();
        }
    }
}

