/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestApiMetadataEncoderTest
extends ClusterTestHarness {
    private static String SCHEMA_STRING = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();

    public RestApiMetadataEncoderTest() {
        super(1, true, CompatibilityLevel.BACKWARD.name);
    }

    @Override
    public Properties getSchemaRegistryProperties() throws Exception {
        Properties props = new Properties();
        props.setProperty("metadata.encoder.secret", "mysecret");
        return props;
    }

    @Test
    public void testRegisterSchemaWithSensitiveMetadata() throws Exception {
        String subject = "testSubject";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("nonsensitive", "foo");
        properties.put("sensitive", "foo");
        Metadata metadata = new Metadata(null, properties, Collections.singleton("sensitive"));
        Schema schema = new Schema(subject, null, null, null, null, metadata, null, SCHEMA_STRING);
        RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(request, subject, false).getId(), (String)"Registering without id should succeed");
        List subjectVersions = this.restApp.restClient.getAllVersionsById(1);
        Assertions.assertEquals((Object)ImmutableList.of((Object)new SubjectVersion(subject, Integer.valueOf(1))), (Object)subjectVersions);
        SchemaString schemaString = this.restApp.restClient.getId(expectedIdSchema1);
        Assertions.assertEquals(properties, (Object)schemaString.getMetadata().getProperties());
    }

    @Test
    public void testMissingEncoder() throws Exception {
        String subject = "testSubject";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("nonsensitive", "foo");
        properties.put("sensitive", "foo");
        Metadata metadata = new Metadata(null, properties, Collections.singleton("sensitive"));
        Schema schema = new Schema(subject, null, null, null, null, metadata, null, SCHEMA_STRING);
        RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(request, subject, false).getId(), (String)"Registering without id should succeed");
        this.restApp.schemaRegistry().getMetadataEncoder().getEncoders().remove((Object)"default");
        Assertions.assertThrows(RestClientException.class, () -> this.restApp.restClient.getAllVersionsById(1), (String)"Should fail to get schema");
        Assertions.assertThrows(RestClientException.class, () -> this.restApp.restClient.getId(expectedIdSchema1), (String)"Should fail to get schema");
        Assertions.assertThrows(RestClientException.class, () -> this.restApp.restClient.getVersion(subject, 1), (String)"Should fail to get schema");
        Assertions.assertThrows(RestClientException.class, () -> this.restApp.restClient.getLatestVersion(subject), (String)"Should fail to get schema");
        Assertions.assertThrows(RestClientException.class, () -> this.restApp.restClient.getLatestVersion(subject), (String)"Should fail to get schema");
        List schemas = this.restApp.restClient.getSchemas(subject, true, false);
        Assertions.assertTrue((boolean)schemas.isEmpty());
        List subjects = this.restApp.restClient.getAllSubjects();
        Assertions.assertTrue((boolean)subjects.isEmpty());
    }
}

