/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.id.IdGenerator;
import io.confluent.kafka.schemaregistry.id.IncrementalIdGenerator;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.ClearSubjectKey;
import io.confluent.kafka.schemaregistry.storage.CloseableIterator;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectKey;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectValue;
import io.confluent.kafka.schemaregistry.storage.InMemoryCache;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.KafkaStoreMessageHandler;
import io.confluent.kafka.schemaregistry.storage.LookupCache;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.Store;
import io.confluent.kafka.schemaregistry.storage.StoreUtils;
import io.confluent.kafka.schemaregistry.storage.StringSerializer;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import io.confluent.kafka.schemaregistry.storage.serialization.SchemaRegistrySerializer;
import io.confluent.kafka.schemaregistry.storage.serialization.Serializer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KafkaStoreTest
extends ClusterTestHarness {
    private static final int ADMIN_TIMEOUT_SEC = 60;
    private static final TopicPartition tp = new TopicPartition("_schemas", 0);

    @Test
    public void testInitialization() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.brokerList);
        kafkaStore.close();
    }

    @Test
    public void testDoubleInitialization() {
        Assertions.assertThrows(StoreInitializationException.class, () -> {
            try (KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.brokerList);){
                kafkaStore.init();
            }
        });
    }

    @Test
    public void testSimplePut() throws Exception {
        try (KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.brokerList);){
            String key = "Kafka";
            String value = "Rocks";
            kafkaStore.put((Object)key, (Object)value);
            String retrievedValue = (String)kafkaStore.get((Object)key);
            Assertions.assertEquals((Object)value, (Object)retrievedValue, (String)"Retrieved value should match entered value");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleGetAfterFailure() throws Exception {
        String retrievedValue;
        InMemoryCache inMemoryStore = new InMemoryCache((Serializer)StringSerializer.INSTANCE);
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.brokerList, (Store<String, String>)inMemoryStore);
        String key = "Kafka";
        String value = "Rocks";
        try {
            try {
                kafkaStore.put((Object)key, (Object)value);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store put(Kafka, Rocks) operation failed", e);
            }
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assertions.assertEquals((Object)value, (Object)retrievedValue, (String)"Retrieved value should match entered value");
        }
        finally {
            kafkaStore.close();
        }
        kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.brokerList, (Store<String, String>)inMemoryStore);
        try {
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assertions.assertEquals((Object)value, (Object)retrievedValue, (String)"Retrieved value should match entered value");
        }
        finally {
            kafkaStore.close();
        }
    }

    @Test
    public void testSimpleDelete() throws Exception {
        try (KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.brokerList);){
            String retrievedValue;
            String key = "Kafka";
            String value = "Rocks";
            try {
                kafkaStore.put((Object)key, (Object)value);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store put(Kafka, Rocks) operation failed", e);
            }
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assertions.assertEquals((Object)value, (Object)retrievedValue, (String)"Retrieved value should match entered value");
            try {
                kafkaStore.delete((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store delete(Kafka) operation failed", e);
            }
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assertions.assertNull((Object)retrievedValue, (String)"Value should have been deleted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAfterRestart() throws Exception {
        InMemoryCache inMemoryStore = new InMemoryCache((Serializer)StringSerializer.INSTANCE);
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.brokerList, (Store<String, String>)inMemoryStore);
        String key = "Kafka";
        String value = "Rocks";
        try {
            String retrievedValue;
            try {
                kafkaStore.put((Object)key, (Object)value);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store put(Kafka, Rocks) operation failed", e);
            }
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assertions.assertEquals((Object)value, (Object)retrievedValue, (String)"Retrieved value should match entered value");
            try {
                kafkaStore.delete((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store delete(Kafka) operation failed", e);
            }
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assertions.assertNull((Object)retrievedValue, (String)"Value should have been deleted");
            kafkaStore.close();
            kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.brokerList, (Store<String, String>)inMemoryStore);
            retrievedValue = value;
            try {
                retrievedValue = (String)kafkaStore.get((Object)key);
            }
            catch (StoreException e) {
                throw new RuntimeException("Kafka store get(Kafka) operation failed", e);
            }
            Assertions.assertNull((Object)retrievedValue, (String)"Value should have been deleted");
        }
        finally {
            kafkaStore.close();
        }
    }

    @Test
    public void testCustomGroupIdConfig() throws Exception {
        InMemoryCache inMemoryStore = new InMemoryCache((Serializer)StringSerializer.INSTANCE);
        String groupId = "test-group-id";
        Properties props = new Properties();
        props.put("kafkastore.group.id", groupId);
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.brokerList, (Store<String, String>)inMemoryStore, props);
        Assertions.assertEquals((Object)groupId, (Object)kafkaStore.getKafkaStoreReaderThread().getConsumerProperty("group.id"));
    }

    @Test
    public void testDefaultGroupIdConfig() throws Exception {
        InMemoryCache inMemoryStore = new InMemoryCache((Serializer)StringSerializer.INSTANCE);
        Properties props = new Properties();
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.brokerList, (Store<String, String>)inMemoryStore, props);
        Assertions.assertTrue((boolean)kafkaStore.getKafkaStoreReaderThread().getConsumerProperty("group.id").startsWith("schema-registry-"));
    }

    @Test
    public void testMandatoryCompactionPolicy() {
        Assertions.assertThrows(StoreInitializationException.class, () -> {
            Properties kafkaProps = new Properties();
            HashMap<String, String> topicProps = new HashMap<String, String>();
            topicProps.put("cleanup.policy", "delete");
            NewTopic topic = new NewTopic("_schemas", 1, 1);
            topic.configs(topicProps);
            Properties props = new Properties();
            props.put("bootstrap.servers", this.brokerList);
            try (AdminClient admin = AdminClient.create((Properties)props);){
                admin.createTopics(Collections.singletonList(topic)).all().get(60L, TimeUnit.SECONDS);
            }
            InMemoryCache inMemoryStore = new InMemoryCache((Serializer)StringSerializer.INSTANCE);
            KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitKafkaStoreInstance(this.brokerList, (Store<String, String>)inMemoryStore, kafkaProps);
        });
    }

    @Test
    public void testTooManyPartitions() {
        Assertions.assertThrows(StoreInitializationException.class, () -> {
            Properties kafkaProps = new Properties();
            HashMap<String, String> topicProps = new HashMap<String, String>();
            topicProps.put("cleanup.policy", "compact");
            NewTopic topic = new NewTopic("_schemas", 3, 1);
            topic.configs(topicProps);
            Properties props = new Properties();
            props.put("bootstrap.servers", this.brokerList);
            try (AdminClient admin = AdminClient.create((Properties)props);){
                admin.createTopics(Collections.singletonList(topic)).all().get(60L, TimeUnit.SECONDS);
            }
            InMemoryCache inMemoryStore = new InMemoryCache((Serializer)StringSerializer.INSTANCE);
            StoreUtils.createAndInitKafkaStoreInstance(this.brokerList, (Store<String, String>)inMemoryStore, kafkaProps);
        });
    }

    @Test
    public void testTopicAdditionalConfigs() throws Exception {
        Map topicConfigs;
        Properties kafkaProps = new Properties();
        kafkaProps.put("kafkastore.topic.config.delete.retention.ms", "10000");
        kafkaProps.put("kafkastore.topic.config.segment.ms", "10000");
        InMemoryCache inMemoryStore = new InMemoryCache((Serializer)StringSerializer.INSTANCE);
        StoreUtils.createAndInitKafkaStoreInstance(this.brokerList, (Store<String, String>)inMemoryStore, kafkaProps);
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, "_schemas");
        try (AdminClient admin = AdminClient.create((Properties)props);){
            topicConfigs = (Map)admin.describeConfigs(Collections.singleton(configResource)).all().get(60L, TimeUnit.SECONDS);
        }
        Config config = (Config)topicConfigs.get(configResource);
        Assertions.assertNotNull((Object)config.get("delete.retention.ms"));
        Assertions.assertEquals((Object)"10000", (Object)config.get("delete.retention.ms").value());
        Assertions.assertNotNull((Object)config.get("segment.ms"));
        Assertions.assertEquals((Object)"10000", (Object)config.get("segment.ms").value());
    }

    @Test
    public void testGetAlwaysTrueHostnameVerifierWhenSslEndpointIdentificationAlgorithmIsNotSet() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.brokerList);
        props.put("kafkastore.topic", "_schemas");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        Assertions.assertTrue((boolean)schemaRegistry.getHostnameVerifier().verify("", null));
    }

    @Test
    public void testGetAlwaysTrueHostnameVerifierWhenSslEndpointIdentificationAlgorithmIsNone() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.brokerList);
        props.put("kafkastore.topic", "_schemas");
        props.put("ssl.endpoint.identification.algorithm", "none");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        Assertions.assertTrue((boolean)schemaRegistry.getHostnameVerifier().verify("", null));
    }

    @Test
    public void testGetAlwaysTrueHostnameVerifierWhenSslEndpointIdentificationAlgorithmIsEmptyString() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.brokerList);
        props.put("kafkastore.topic", "_schemas");
        props.put("ssl.endpoint.identification.algorithm", "");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        Assertions.assertTrue((boolean)schemaRegistry.getHostnameVerifier().verify("", null));
    }

    @Test
    public void testGetNullHostnameVerifierWhenSslEndpointIdentificationAlgorithmIsHttps() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.brokerList);
        props.put("kafkastore.topic", "_schemas");
        props.put("ssl.endpoint.identification.algorithm", "https");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        Assertions.assertNull((Object)schemaRegistry.getHostnameVerifier());
    }

    @Test
    public void testKafkaStoreMessageHandlerSameIdDifferentSchema() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.brokerList);
        props.put("kafkastore.topic", "_schemas");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        KafkaStore kafkaStore = schemaRegistry.kafkaStore;
        kafkaStore.init();
        int id = 100;
        kafkaStore.put((Object)new SchemaKey("subject", 1), (Object)new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        kafkaStore.put((Object)new SchemaKey("subject2", 1), (Object)new SchemaValue("subject2", Integer.valueOf(1), Integer.valueOf(id), "schemaString2", false));
        int size = 0;
        try (CloseableIterator keys = kafkaStore.getAllKeys();){
            while (keys.hasNext()) {
                ++size;
                keys.next();
            }
        }
        Assertions.assertEquals((int)1, (int)size);
    }

    @Test
    public void testKafkaStoreMessageHandlerSameIdSameSchema() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.brokerList);
        props.put("kafkastore.topic", "_schemas");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        KafkaStore kafkaStore = schemaRegistry.kafkaStore;
        kafkaStore.init();
        int id = 100;
        kafkaStore.put((Object)new SchemaKey("subject", 1), (Object)new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        kafkaStore.put((Object)new SchemaKey("subject2", 1), (Object)new SchemaValue("subject2", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        int size = 0;
        try (CloseableIterator keys = kafkaStore.getAllKeys();){
            while (keys.hasNext()) {
                ++size;
                keys.next();
            }
        }
        Assertions.assertEquals((int)2, (int)size);
    }

    @Test
    public void testKafkaStoreMessageHandlerSameIdDifferentDeletedSchema() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.brokerList);
        props.put("kafkastore.topic", "_schemas");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        KafkaStore kafkaStore = schemaRegistry.kafkaStore;
        kafkaStore.init();
        int id = 100;
        kafkaStore.put((Object)new SchemaKey("subject", 1), (Object)new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        kafkaStore.put((Object)new SchemaKey("subject", 1), (Object)new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(id), "schemaString", true));
        kafkaStore.put((Object)new SchemaKey("subject2", 1), (Object)new SchemaValue("subject2", Integer.valueOf(1), Integer.valueOf(id), "schemaString2", false));
        int size = 0;
        try (CloseableIterator keys = kafkaStore.getAllKeys();){
            while (keys.hasNext()) {
                ++size;
                keys.next();
            }
        }
        Assertions.assertEquals((int)1, (int)size);
    }

    @Test
    public void testKafkaStoreMessageHandlerSameIdSameDeletedSchema() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.brokerList);
        props.put("kafkastore.topic", "_schemas");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        KafkaStore kafkaStore = schemaRegistry.kafkaStore;
        kafkaStore.init();
        int id = 100;
        kafkaStore.put((Object)new SchemaKey("subject", 1), (Object)new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        kafkaStore.put((Object)new SchemaKey("subject", 1), (Object)new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(id), "schemaString", true));
        kafkaStore.put((Object)new SchemaKey("subject2", 1), (Object)new SchemaValue("subject2", Integer.valueOf(1), Integer.valueOf(id), "schemaString", false));
        int size = 0;
        try (CloseableIterator keys = kafkaStore.getAllKeys();){
            while (keys.hasNext()) {
                ++size;
                keys.next();
            }
        }
        Assertions.assertEquals((int)2, (int)size);
    }

    @Test
    public void testKafkaStoreMessageHandlerDeleteSubjectKeyNullValue() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.brokerList);
        props.put("kafkastore.topic", "_schemas");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        InMemoryCache store = new InMemoryCache((Serializer)new SchemaRegistrySerializer());
        store.init();
        KafkaStoreMessageHandler storeMessageHandler = new KafkaStoreMessageHandler((SchemaRegistry)schemaRegistry, (LookupCache)store, (IdGenerator)new IncrementalIdGenerator((SchemaRegistry)schemaRegistry));
        storeMessageHandler.handleUpdate((SchemaRegistryKey)new DeleteSubjectKey("test"), null, null, tp, 0L, 0L);
        Assertions.assertEquals((Long)1L, (Long)((Long)storeMessageHandler.checkpoint(1).get(tp)));
    }

    @Test
    public void testKafkaStoreMessageHandlerClearSubjectKeyNullValue() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.brokerList);
        props.put("kafkastore.topic", "_schemas");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        InMemoryCache store = new InMemoryCache((Serializer)new SchemaRegistrySerializer());
        store.init();
        KafkaStoreMessageHandler storeMessageHandler = new KafkaStoreMessageHandler((SchemaRegistry)schemaRegistry, (LookupCache)store, (IdGenerator)new IncrementalIdGenerator((SchemaRegistry)schemaRegistry));
        storeMessageHandler.handleUpdate((SchemaRegistryKey)new ClearSubjectKey("test"), null, null, tp, 0L, 0L);
        Assertions.assertEquals((Long)1L, (Long)((Long)storeMessageHandler.checkpoint(1).get(tp)));
    }

    @Test
    public void testKafkaStoreMessageHandlerDeleteSubjectSkipsAlreadyDeletedVersions() throws Exception {
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.brokerList);
        props.put("kafkastore.topic", "_schemas");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        KafkaSchemaRegistry schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        TrackingInMemoryCache store = new TrackingInMemoryCache(new SchemaRegistrySerializer());
        store.init();
        KafkaStoreMessageHandler storeMessageHandler = new KafkaStoreMessageHandler((SchemaRegistry)schemaRegistry, (LookupCache)store, (IdGenerator)new IncrementalIdGenerator((SchemaRegistry)schemaRegistry));
        String subject = "test-subject";
        SchemaKey key1 = new SchemaKey(subject, 1);
        SchemaValue value1 = new SchemaValue(subject, Integer.valueOf(1), Integer.valueOf(100), "schema1", true);
        SchemaKey key2 = new SchemaKey(subject, 2);
        SchemaValue value2 = new SchemaValue(subject, Integer.valueOf(2), Integer.valueOf(101), "schema2", false);
        SchemaKey key3 = new SchemaKey(subject, 3);
        SchemaValue value3 = new SchemaValue(subject, Integer.valueOf(3), Integer.valueOf(102), "schema3", true);
        SchemaKey key4 = new SchemaKey(subject, 4);
        SchemaValue value4 = new SchemaValue(subject, Integer.valueOf(4), Integer.valueOf(103), "schema4", false);
        SchemaKey key5 = new SchemaKey(subject, 5);
        SchemaValue value5 = new SchemaValue(subject, Integer.valueOf(5), Integer.valueOf(104), "schema5", false);
        store.put((SchemaRegistryKey)key1, (SchemaRegistryValue)value1);
        store.put((SchemaRegistryKey)key2, (SchemaRegistryValue)value2);
        store.put((SchemaRegistryKey)key3, (SchemaRegistryValue)value3);
        store.put((SchemaRegistryKey)key4, (SchemaRegistryValue)value4);
        store.put((SchemaRegistryKey)key5, (SchemaRegistryValue)value5);
        store.resetCounts();
        DeleteSubjectValue deleteSubjectValue = new DeleteSubjectValue(subject, Integer.valueOf(5));
        storeMessageHandler.handleUpdate((SchemaRegistryKey)new DeleteSubjectKey(subject), (SchemaRegistryValue)deleteSubjectValue, null, tp, 0L, 0L);
        Assertions.assertEquals((int)3, (int)store.getPutCount(), (String)"Should only process non-deleted schemas with put()");
        Assertions.assertEquals((int)3, (int)store.getSchemaDeletedCount(), (String)"Should only process non-deleted schemas with schemaDeleted()");
        Assertions.assertTrue((boolean)((SchemaValue)store.get(key1)).isDeleted(), (String)"Version 1 should be deleted");
        Assertions.assertTrue((boolean)((SchemaValue)store.get(key2)).isDeleted(), (String)"Version 2 should be deleted");
        Assertions.assertTrue((boolean)((SchemaValue)store.get(key3)).isDeleted(), (String)"Version 3 should be deleted");
        Assertions.assertTrue((boolean)((SchemaValue)store.get(key4)).isDeleted(), (String)"Version 4 should be deleted");
        Assertions.assertTrue((boolean)((SchemaValue)store.get(key5)).isDeleted(), (String)"Version 5 should be deleted");
        storeMessageHandler.close();
    }

    private static class TrackingInMemoryCache
    extends InMemoryCache<SchemaRegistryKey, SchemaRegistryValue> {
        private int putCount = 0;
        private int schemaDeletedCount = 0;

        public TrackingInMemoryCache(SchemaRegistrySerializer serializer) {
            super((Serializer)serializer);
        }

        public SchemaRegistryValue put(SchemaRegistryKey key, SchemaRegistryValue value) throws StoreException {
            ++this.putCount;
            return (SchemaRegistryValue)super.put((Object)key, (Object)value);
        }

        public void schemaDeleted(SchemaKey schemaKey, SchemaValue schemaValue, SchemaValue oldSchemaValue) {
            ++this.schemaDeletedCount;
            super.schemaDeleted(schemaKey, schemaValue, oldSchemaValue);
        }

        public int getPutCount() {
            return this.putCount;
        }

        public int getSchemaDeletedCount() {
            return this.schemaDeletedCount;
        }

        public void resetCounts() {
            this.putCount = 0;
            this.schemaDeletedCount = 0;
        }
    }
}

