/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleKind;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.storage.MD5;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class SchemaMD5RegressionTest {
    private List<SchemaReference> testReferences;
    private Metadata testMetadata;
    private RuleSet testRuleSet;
    private String avroSchemaString;
    private String protobufSchemaString;
    private String jsonSchemaString;

    private Schema createSchema(String subject, Integer version, Integer id, String schemaString, String schemaType, List<SchemaReference> references, Metadata metadata, RuleSet ruleSet) {
        Schema schema = new Schema(subject, version, id);
        schema.setSchemaType(schemaType);
        schema.setSchema(schemaString);
        if (references != null) {
            schema.setReferences(references);
        }
        if (metadata != null) {
            schema.setMetadata(metadata);
        }
        if (ruleSet != null) {
            schema.setRuleSet(ruleSet);
        }
        return schema;
    }

    private String calculateMD5Hash(Schema schema) {
        MD5 md5 = MD5.ofSchema((Schema)schema);
        byte[] bytes = md5.bytes();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long msb = buffer.getLong();
        long lsb = buffer.getLong();
        return new UUID(msb, lsb).toString();
    }

    private void loadTestDataFromGoldenFile(JsonNode goldenData) {
        JsonNode schemasNode = goldenData.get("schemas");
        this.avroSchemaString = schemasNode.get("avro").asText();
        this.protobufSchemaString = schemasNode.get("protobuf").asText();
        this.jsonSchemaString = schemasNode.get("json").asText();
        JsonNode referencesNode = goldenData.get("references");
        this.testReferences = new ArrayList<SchemaReference>();
        for (JsonNode refNode : referencesNode) {
            this.testReferences.add(new SchemaReference(refNode.get("name").asText(), refNode.get("subject").asText(), Integer.valueOf(refNode.get("version").asInt())));
        }
        JsonNode metadataNode = goldenData.get("metadata");
        TreeMap<String, Object> tags = new TreeMap<String, Object>();
        JsonNode tagsNode = metadataNode.get("tags");
        for (String tagKey : () -> tagsNode.fieldNames()) {
            TreeSet tagValues = new TreeSet();
            for (JsonNode tagValue : tagsNode.get(tagKey)) {
                tagValues.add(tagValue.asText());
            }
            tags.put(tagKey, tagValues);
        }
        TreeMap<String, String> properties = new TreeMap<String, String>();
        JsonNode propertiesNode = metadataNode.get("properties");
        for (Object propKey : () -> propertiesNode.fieldNames()) {
            properties.put((String)propKey, propertiesNode.get((String)propKey).asText());
        }
        TreeSet<String> sensitive = new TreeSet<String>();
        for (JsonNode sensitiveNode : metadataNode.get("sensitive")) {
            sensitive.add(sensitiveNode.asText());
        }
        this.testMetadata = new Metadata(tags, properties, sensitive);
        JsonNode rulesNode = goldenData.get("rules");
        ArrayList<Rule> migrationRules = new ArrayList<Rule>();
        JsonNode migrationRulesNode = rulesNode.get("migrationRules");
        for (JsonNode ruleNode : migrationRulesNode) {
            TreeSet<String> tagsSet = new TreeSet<String>();
            for (JsonNode tagNode : ruleNode.get("tags")) {
                tagsSet.add(tagNode.asText());
            }
            TreeMap<String, String> params = new TreeMap<String, String>();
            JsonNode paramsNode = ruleNode.get("params");
            for (String paramKey : () -> paramsNode.fieldNames()) {
                params.put(paramKey, paramsNode.get(paramKey).asText());
            }
            migrationRules.add(new Rule(ruleNode.get("name").asText(), ruleNode.get("doc").asText(), RuleKind.valueOf((String)ruleNode.get("kind").asText()), RuleMode.valueOf((String)ruleNode.get("mode").asText()), ruleNode.get("type").asText(), tagsSet, params, ruleNode.get("expr").asText(), ruleNode.get("onSuccess").asText(), ruleNode.get("onFailure").asText(), ruleNode.get("disabled").asBoolean()));
        }
        ArrayList<Rule> domainRules = new ArrayList<Rule>();
        JsonNode domainRulesNode = rulesNode.get("domainRules");
        for (JsonNode ruleNode : domainRulesNode) {
            TreeSet<String> tagsSet = new TreeSet<String>();
            for (JsonNode tagNode : ruleNode.get("tags")) {
                tagsSet.add(tagNode.asText());
            }
            TreeMap<String, String> params = new TreeMap<String, String>();
            JsonNode paramsNode = ruleNode.get("params");
            for (String paramKey : () -> paramsNode.fieldNames()) {
                params.put(paramKey, paramsNode.get(paramKey).asText());
            }
            domainRules.add(new Rule(ruleNode.get("name").asText(), ruleNode.get("doc").asText(), RuleKind.valueOf((String)ruleNode.get("kind").asText()), RuleMode.valueOf((String)ruleNode.get("mode").asText()), ruleNode.get("type").asText(), tagsSet, params, ruleNode.get("expr").asText(), ruleNode.get("onSuccess").asText(), ruleNode.get("onFailure").asText(), ruleNode.get("disabled").asBoolean()));
        }
        this.testRuleSet = new RuleSet(migrationRules, domainRules);
    }

    private void printAllHashValues() {
        String[] schemaTypes = new String[]{"AVRO", "PROTOBUF", "JSON"};
        String[] schemaStrings = new String[]{this.avroSchemaString, this.protobufSchemaString, this.jsonSchemaString};
        for (int schemaTypeIndex = 0; schemaTypeIndex < 3; ++schemaTypeIndex) {
            String schemaType = schemaTypes[schemaTypeIndex];
            String schemaString = schemaStrings[schemaTypeIndex];
            System.out.println(String.format("Testing %s schema:", schemaType));
            for (int i = 0; i < 8; ++i) {
                boolean hasReferences = (i & 4) != 0;
                boolean hasMetadata = (i & 2) != 0;
                boolean hasRules = (i & 1) != 0;
                Schema schema = this.createSchema("Person", 1, 100, schemaString, schemaType, hasReferences ? this.testReferences : null, hasMetadata ? this.testMetadata : null, hasRules ? this.testRuleSet : null);
                String hash = this.calculateMD5Hash(schema);
                System.out.println(hash);
            }
        }
    }

    @Test
    public void testGoldenMD5Consistency() throws NoSuchAlgorithmException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        InputStream goldenFileStream = this.getClass().getClassLoader().getResourceAsStream("schema-md5-golden-data.json");
        Assert.assertNotNull((String)"Golden file should exist", (Object)goldenFileStream);
        JsonNode goldenData = mapper.readTree(goldenFileStream);
        this.loadTestDataFromGoldenFile(goldenData);
        String[] schemaTypes = new String[]{"AVRO", "PROTOBUF", "JSON"};
        String[] schemaStrings = new String[]{this.avroSchemaString, this.protobufSchemaString, this.jsonSchemaString};
        for (int schemaTypeIndex = 0; schemaTypeIndex < 3; ++schemaTypeIndex) {
            String schemaType = schemaTypes[schemaTypeIndex];
            String schemaString = schemaStrings[schemaTypeIndex];
            JsonNode expectedHashes = goldenData.get("expectedHashes").get(schemaType);
            for (int i = 0; i < 8; ++i) {
                boolean hasReferences = (i & 4) != 0;
                boolean hasMetadata = (i & 2) != 0;
                boolean hasRules = (i & 1) != 0;
                Schema schema = this.createSchema("Person", 1, 100, schemaString, schemaType, hasReferences ? this.testReferences : null, hasMetadata ? this.testMetadata : null, hasRules ? this.testRuleSet : null);
                String actualHash = this.calculateMD5Hash(schema);
                String combinationKey = String.format("%3s", Integer.toBinaryString(i)).replace(' ', '0');
                String expectedHash = expectedHashes.get(combinationKey).asText();
                Assert.assertEquals((String)String.format("Hash mismatch for %s combination %d (References=%s, Metadata=%s, Rules=%s)", schemaType.toUpperCase(), i, hasReferences, hasMetadata, hasRules), (Object)expectedHash, (Object)actualHash);
            }
        }
    }
}

