/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.ExecuteStatementResult;
import io.confluent.ksql.api.client.exception.KsqlClientException;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;

final class DdlDmlRequestValidators {
    private static final String QUOTED_STRING_OR_IDENTIFIER_PIECE = "(`[^`]*`)|('[^']*')";

    private DdlDmlRequestValidators() {
    }

    static boolean validateExecuteStatementRequest(String sql, CompletableFuture<ExecuteStatementResult> cf) {
        if (!sql.contains(";")) {
            cf.completeExceptionally(new KsqlClientException("Missing semicolon in SQL for executeStatement() request."));
            return false;
        }
        if (DdlDmlRequestValidators.countStatements(sql) > 1) {
            cf.completeExceptionally(new KsqlClientException("executeStatement() may only be used to execute one statement at a time."));
            return false;
        }
        return true;
    }

    private static int countStatements(String sql) {
        return Arrays.stream(sql.split(QUOTED_STRING_OR_IDENTIFIER_PIECE)).mapToInt(part -> part.split(";", -1).length - 1).sum();
    }
}

