/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.BatchedQueryResult;
import io.confluent.ksql.api.client.ColumnType;
import io.confluent.ksql.api.client.Row;
import io.confluent.ksql.api.client.exception.KsqlClientException;
import io.confluent.ksql.api.client.impl.QueryResponseHandler;
import io.confluent.ksql.api.client.impl.RowImpl;
import io.confluent.ksql.api.client.util.RowUtil;
import io.confluent.ksql.rest.entity.QueryResponseMetadata;
import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.parsetools.RecordParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteQueryResponseHandler
extends QueryResponseHandler<BatchedQueryResult> {
    private static final Logger log = LoggerFactory.getLogger(ExecuteQueryResponseHandler.class);
    private final List<Row> rows;
    private final int maxRows;
    private List<String> columnNames;
    private List<ColumnType> columnTypes;
    private Map<String, Integer> columnNameToIndex;
    private AtomicReference<String> serializedConsistencyVector;

    ExecuteQueryResponseHandler(Context context, RecordParser recordParser, BatchedQueryResult cf, int maxRows, AtomicReference<String> serializedCV) {
        super(context, recordParser, cf);
        this.maxRows = maxRows;
        this.rows = new ArrayList<Row>();
        this.serializedConsistencyVector = Objects.requireNonNull(serializedCV, "serializedCV");
    }

    @Override
    protected void handleMetadata(QueryResponseMetadata queryResponseMetadata) {
        ((BatchedQueryResult)this.cf).queryID().complete(queryResponseMetadata.queryId);
        this.columnNames = queryResponseMetadata.columnNames;
        this.columnTypes = RowUtil.columnTypesFromStrings(queryResponseMetadata.columnTypes);
        this.columnNameToIndex = RowUtil.valueToIndexMap(this.columnNames);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void handleRow(Buffer buff) {
        JsonObject json = buff.toJsonObject();
        if (json.containsKey("finalMessage")) return;
        if (!json.containsKey("row")) throw new RuntimeException("Could not decode JSON: " + json);
        if (this.rows.size() >= this.maxRows) throw new KsqlClientException("Reached max number of rows that may be returned by executeQuery(). Increase the limit via ClientOptions#setExecuteQueryMaxResultRows(). Current limit: " + this.maxRows);
        this.rows.add(new RowImpl(this.columnNames, this.columnTypes, new JsonArray((List)((Map)json.getMap().get("row")).get("columns")), this.columnNameToIndex));
    }

    @Override
    protected void doHandleBodyEnd() {
        if (!this.hasReadArguments) {
            throw new IllegalStateException("Body ended before metadata received");
        }
        ((BatchedQueryResult)this.cf).complete(this.rows);
    }

    @Override
    public void handleExceptionAfterFutureCompleted(Throwable t) {
        log.error("Exceptions should not occur after the future has been completed", t);
    }
}

