/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.api.client.exception.KsqlClientException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;

public class HttpResponseImpl
implements Client.HttpResponse {
    private final int status;
    private final byte[] body;

    public HttpResponseImpl(int status, byte[] body) {
        this.status = status;
        if (body == null) {
            this.body = null;
        } else {
            this.body = new byte[body.length];
            System.arraycopy(body, 0, this.body, 0, body.length);
        }
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public byte[] body() {
        if (this.body == null) {
            return null;
        }
        byte[] copy = new byte[this.body.length];
        System.arraycopy(this.body, 0, copy, 0, this.body.length);
        return copy;
    }

    @Override
    public <T> Map<String, T> bodyAsMap() {
        if (this.body == null) {
            return Collections.emptyMap();
        }
        try {
            JsonObject object = new JsonObject(Buffer.buffer((byte[])this.body));
            return object.getMap();
        }
        catch (DecodeException e) {
            throw new KsqlClientException("Could not decode response: " + new String(this.body, StandardCharsets.UTF_8));
        }
    }
}

