/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.client.ColumnType;
import io.confluent.ksql.api.client.KsqlArray;
import io.confluent.ksql.api.client.KsqlObject;
import io.confluent.ksql.api.client.Row;
import io.vertx.core.json.JsonArray;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RowImpl
implements Row {
    private final ImmutableList<String> columnNames;
    private final ImmutableList<ColumnType> columnTypes;
    private final KsqlArray values;
    private final ImmutableMap<String, Integer> columnNameToIndex;

    public RowImpl(List<String> columnNames, List<ColumnType> columnTypes, JsonArray values, Map<String, Integer> columnNameToIndex) {
        this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames));
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes));
        this.values = new KsqlArray(Objects.requireNonNull(values).getList());
        this.columnNameToIndex = ImmutableMap.copyOf(Objects.requireNonNull(columnNameToIndex));
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="columnNames is ImmutableList")
    public List<String> columnNames() {
        return this.columnNames;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="columnTypes is ImmutableList")
    public List<ColumnType> columnTypes() {
        return this.columnTypes;
    }

    @Override
    public KsqlArray values() {
        return this.values.copy();
    }

    @Override
    public KsqlObject asObject() {
        return KsqlObject.fromArray(this.columnNames, this.values);
    }

    @Override
    public boolean isNull(int columnIndex) {
        return this.getValue(columnIndex) == null;
    }

    @Override
    public boolean isNull(String columnName) {
        return this.isNull(this.indexFromName(columnName));
    }

    @Override
    public Object getValue(int columnIndex) {
        return this.values.getValue(columnIndex - 1);
    }

    @Override
    public Object getValue(String columnName) {
        return this.getValue(this.indexFromName(columnName));
    }

    @Override
    public String getString(int columnIndex) {
        return this.values.getString(columnIndex - 1);
    }

    @Override
    public String getString(String columnName) {
        return this.getString(this.indexFromName(columnName));
    }

    @Override
    public Integer getInteger(int columnIndex) {
        return this.values.getInteger(columnIndex - 1);
    }

    @Override
    public Integer getInteger(String columnName) {
        return this.getInteger(this.indexFromName(columnName));
    }

    @Override
    public Long getLong(int columnIndex) {
        return this.values.getLong(columnIndex - 1);
    }

    @Override
    public Long getLong(String columnName) {
        return this.getLong(this.indexFromName(columnName));
    }

    @Override
    public Double getDouble(int columnIndex) {
        return this.values.getDouble(columnIndex - 1);
    }

    @Override
    public Double getDouble(String columnName) {
        return this.getDouble(this.indexFromName(columnName));
    }

    @Override
    public Boolean getBoolean(int columnIndex) {
        return this.values.getBoolean(columnIndex - 1);
    }

    @Override
    public Boolean getBoolean(String columnName) {
        return this.getBoolean(this.indexFromName(columnName));
    }

    @Override
    public BigDecimal getDecimal(int columnIndex) {
        return this.values.getDecimal(columnIndex - 1);
    }

    @Override
    public BigDecimal getDecimal(String columnName) {
        return this.getDecimal(this.indexFromName(columnName));
    }

    @Override
    public byte[] getBytes(int columnIndex) {
        return this.values.getBytes(columnIndex - 1);
    }

    @Override
    public byte[] getBytes(String columnName) {
        return this.getBytes(this.indexFromName(columnName));
    }

    @Override
    public KsqlObject getKsqlObject(int columnIndex) {
        return this.values.getKsqlObject(columnIndex - 1);
    }

    @Override
    public KsqlObject getKsqlObject(String columnName) {
        return this.getKsqlObject(this.indexFromName(columnName));
    }

    @Override
    public KsqlArray getKsqlArray(int columnIndex) {
        return this.values.getKsqlArray(columnIndex - 1);
    }

    @Override
    public KsqlArray getKsqlArray(String columnName) {
        return this.getKsqlArray(this.indexFromName(columnName));
    }

    private int indexFromName(String columnName) {
        Integer index = (Integer)this.columnNameToIndex.get((Object)columnName);
        if (index == null) {
            throw new IllegalArgumentException("No column exists with name: " + columnName);
        }
        return index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowImpl row = (RowImpl)o;
        return this.columnNames.equals(row.columnNames) && this.columnTypes.equals(row.columnTypes) && this.values.equals(row.values);
    }

    public int hashCode() {
        return Objects.hash(this.columnNames, this.columnTypes, this.values);
    }

    public String toString() {
        return "Row{columnNames=" + this.columnNames + ", columnTypes=" + this.columnTypes + ", values=" + this.values + '}';
    }
}

