/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SystemColumns {
    public static final ColumnName ROWKEY_NAME = ColumnName.of("ROWKEY");
    public static final ColumnName ROWTIME_NAME = ColumnName.of("ROWTIME");
    public static final SqlType ROWTIME_TYPE = SqlTypes.BIGINT;
    public static final ColumnName ROWPARTITION_NAME = ColumnName.of("ROWPARTITION");
    public static final SqlType ROWPARTITION_TYPE = SqlTypes.INTEGER;
    public static final ColumnName ROWOFFSET_NAME = ColumnName.of("ROWOFFSET");
    public static final SqlType ROWOFFSET_TYPE = SqlTypes.BIGINT;
    public static final ColumnName WINDOWSTART_NAME = ColumnName.of("WINDOWSTART");
    public static final ColumnName WINDOWEND_NAME = ColumnName.of("WINDOWEND");
    public static final SqlType WINDOWBOUND_TYPE = SqlTypes.BIGINT;
    public static final int ROWTIME_PSEUDOCOLUMN_VERSION = 0;
    public static final int ROWPARTITION_ROWOFFSET_PSEUDOCOLUMN_VERSION = 1;
    public static final int LEGACY_PSEUDOCOLUMN_VERSION_NUMBER = 0;
    public static final int CURRENT_PSEUDOCOLUMN_VERSION_NUMBER = 1;
    private static final Set<ColumnName> WINDOW_BOUNDS_COLUMN_NAMES = ImmutableSet.of((Object)WINDOWSTART_NAME, (Object)WINDOWEND_NAME);
    public static final SqlType HEADERS_TYPE = SqlArray.of((SqlType)SqlStruct.builder().field("KEY", (SqlType)SqlTypes.STRING).field("VALUE", (SqlType)SqlTypes.BYTES).build());
    private static final List<PseudoColumn> pseudoColumns = ImmutableList.of((Object)PseudoColumn.access$000(ROWTIME_NAME, ROWTIME_TYPE, 0, false, false, false), (Object)PseudoColumn.access$000(ROWPARTITION_NAME, ROWPARTITION_TYPE, 1, true, true, true), (Object)PseudoColumn.access$000(ROWOFFSET_NAME, ROWOFFSET_TYPE, 1, true, true, true));

    private SystemColumns() {
    }

    public static boolean isWindowBound(ColumnName columnName) {
        return SystemColumns.windowBoundsColumnNames().contains(columnName);
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"}, justification="WINDOW_BOUNDS_COLUMN_NAMES is ImmutableSet")
    public static Set<ColumnName> windowBoundsColumnNames() {
        return WINDOW_BOUNDS_COLUMN_NAMES;
    }

    public static boolean isPseudoColumn(ColumnName columnName) {
        return pseudoColumns.stream().anyMatch(col -> col.name.equals(columnName));
    }

    public static Set<ColumnName> pseudoColumnNames() {
        return SystemColumns.pseudoColumnNames(1);
    }

    public static Set<ColumnName> pseudoColumnNames(int pseudoColumnVersion) {
        SystemColumns.validatePseudoColumnVersion(pseudoColumnVersion);
        return pseudoColumns.stream().filter(col -> col.version <= pseudoColumnVersion).map(col -> col.name).collect(Collectors.toSet());
    }

    public static boolean isSystemColumn(ColumnName columnName) {
        return SystemColumns.isSystemColumn(columnName, 1);
    }

    public static boolean isSystemColumn(ColumnName columnName, int pseudoColumnVersion) {
        return SystemColumns.systemColumnNames(pseudoColumnVersion).contains(columnName);
    }

    public static Set<ColumnName> systemColumnNames() {
        return SystemColumns.systemColumnNames(1);
    }

    public static Set<ColumnName> systemColumnNames(int pseudoColumnVersion) {
        return Stream.concat(WINDOW_BOUNDS_COLUMN_NAMES.stream(), SystemColumns.pseudoColumnNames(pseudoColumnVersion).stream()).collect(Collectors.toSet());
    }

    public static boolean mustBeMaterializedForTableJoins(ColumnName columnName) {
        return SystemColumns.pseudoColumns.stream().filter((Predicate<PseudoColumn>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$mustBeMaterializedForTableJoins$3(io.confluent.ksql.name.ColumnName io.confluent.ksql.schema.ksql.SystemColumns$PseudoColumn ), (Lio/confluent/ksql/schema/ksql/SystemColumns$PseudoColumn;)Z)((ColumnName)columnName)).findFirst().orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/IllegalArgumentException;)()).mustBeMaterializedForTableJoins;
    }

    public static boolean isDisallowedForInsertValues(ColumnName columnName) {
        return pseudoColumns.stream().filter(col -> col.name.equals(columnName)).anyMatch(col -> col.isDisallowedForInsertValues);
    }

    public static boolean isDisallowedInPullOrScalablePushQueries(ColumnName columnName) {
        return SystemColumns.isDisallowedInPullOrScalablePushQueries(columnName, 1);
    }

    public static boolean isDisallowedInPullOrScalablePushQueries(ColumnName columnName, int pseudoColumnVersion) {
        return pseudoColumns.stream().filter(col -> col.version <= pseudoColumnVersion).filter(col -> col.isDisallowedInPullAndScalablePushQueries).anyMatch(col -> col.name.equals(columnName));
    }

    private static void validatePseudoColumnVersion(int pseudoColumnVersionNumber) {
        if (pseudoColumnVersionNumber < 0 || pseudoColumnVersionNumber > 1) {
            throw new IllegalArgumentException("Invalid pseudoColumnVersionNumber provided");
        }
    }

    private static /* synthetic */ boolean lambda$mustBeMaterializedForTableJoins$3(ColumnName columnName, PseudoColumn col) {
        return col.name.equals(columnName);
    }

    @Immutable
    private static final class PseudoColumn {
        final ColumnName name;
        final SqlType type;
        final int version;
        final boolean mustBeMaterializedForTableJoins;
        final boolean isDisallowedForInsertValues;
        final boolean isDisallowedInPullAndScalablePushQueries;

        private PseudoColumn(ColumnName name, SqlType type, int version, boolean mustBeMaterializedForTableJoins, boolean isDisallowedForInsertValues, boolean isDisallowedInPullAndScalablePushQueries) {
            this.name = Objects.requireNonNull(name, "name");
            this.type = Objects.requireNonNull(type, "type");
            this.version = version;
            this.mustBeMaterializedForTableJoins = mustBeMaterializedForTableJoins;
            this.isDisallowedForInsertValues = isDisallowedForInsertValues;
            this.isDisallowedInPullAndScalablePushQueries = isDisallowedInPullAndScalablePushQueries;
        }

        private static PseudoColumn of(ColumnName name, SqlType type, int version, boolean mustBeMaterializedForTableJoins, boolean isDisallowedForInsertValues, boolean isDisallowedInPullAndScalablePushQueries) {
            return new PseudoColumn(name, type, version, mustBeMaterializedForTableJoins, isDisallowedForInsertValues, isDisallowedInPullAndScalablePushQueries);
        }

        static /* synthetic */ PseudoColumn access$000(ColumnName x0, SqlType x1, int x2, boolean x3, boolean x4, boolean x5) {
            return PseudoColumn.of(x0, x1, x2, x3, x4, x5);
        }
    }
}

