/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.util.KsqlException;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Optional;

public final class KeystoreUtil {
    private static final String KEYSTORE_TYPE = "JKS";

    private KeystoreUtil() {
    }

    public static Buffer getKeyStore(String keyStoreType, String keyStorePath, Optional<String> keyStorePassword, Optional<String> keyPassword, String alias) {
        Certificate[] chain;
        PrivateKey key;
        char[] pw = keyStorePassword.map(String::toCharArray).orElse(null);
        char[] keyPw = keyPassword.map(String::toCharArray).orElse(null);
        KeyStore keyStore = KeystoreUtil.loadExistingKeyStore(keyStoreType, keyStorePath, pw);
        try {
            key = (PrivateKey)keyStore.getKey(alias, keyPw);
            chain = keyStore.getCertificateChain(alias);
        }
        catch (Exception e) {
            throw new KsqlException("Error fetching key/certificate " + alias, e);
        }
        if (key == null || chain == null) {
            throw new KsqlException("Alias doesn't exist in keystore: " + alias);
        }
        byte[] singleValueKeyStore = KeystoreUtil.createSingleValueKeyStore(key, chain, pw, pw, alias);
        return Buffer.buffer((byte[])singleValueKeyStore);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore loadExistingKeyStore(String keyStoreType, String keyStorePath, char[] pw) {
        try (FileInputStream input = new FileInputStream(keyStorePath);){
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(input, pw);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (Exception e) {
            throw new KsqlException("Couldn't fetch keystore", e);
        }
    }

    private static byte[] createSingleValueKeyStore(PrivateKey key, Certificate[] chain, char[] pw, char[] keyPw, String alias) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore.load(null, null);
            keyStore.setEntry(alias, new KeyStore.PrivateKeyEntry(key, chain), new KeyStore.PasswordProtection(keyPw));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            keyStore.store(outputStream, pw);
            return outputStream.toByteArray();
        }
        catch (Exception e) {
            throw new KsqlException("Couldn't create keystore", e);
        }
    }
}

