/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql;

import java.time.Instant;
import java.util.Objects;

public final class Window {
    private final Instant start;
    private final Instant end;

    public static Window of(Instant start, Instant end) {
        return new Window(start, end);
    }

    private Window(Instant start, Instant end) {
        this.start = Objects.requireNonNull(start, "start");
        this.end = Objects.requireNonNull(end, "end");
        if (end.isBefore(start)) {
            throw new IllegalArgumentException("end before start. start: " + String.valueOf(start) + ", end: " + String.valueOf(end));
        }
    }

    public Instant start() {
        return Instant.from(this.start);
    }

    public Instant end() {
        return Instant.from(this.end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Window window = (Window)o;
        return Objects.equals(this.start, window.start) && Objects.equals(this.end, window.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "Window{start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + "}";
    }
}

