/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.types;

import io.confluent.ksql.function.types.ObjectType;
import io.confluent.ksql.function.types.ParamType;
import java.util.Objects;

public final class MapType
extends ObjectType {
    private final ParamType key;
    private final ParamType value;

    private MapType(ParamType key, ParamType value) {
        this.key = Objects.requireNonNull(key, "key");
        this.value = Objects.requireNonNull(value, "value");
    }

    public static MapType of(ParamType key, ParamType value) {
        return new MapType(key, value);
    }

    public ParamType key() {
        return this.key;
    }

    public ParamType value() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapType mapType = (MapType)o;
        return Objects.equals(this.key, mapType.key) && Objects.equals(this.value, mapType.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    @Override
    public String toString() {
        return "MAP<" + String.valueOf(this.key) + ", " + String.valueOf(this.value) + ">";
    }
}

