/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logging.processing;

import io.confluent.ksql.logging.processing.ProcessingLogConfig;
import io.confluent.ksql.logging.processing.ProcessingLogMessageSchema;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.SerializableSchemaAndValue;
import java.util.Objects;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.logging.log4j.Logger;

public class ProcessingLoggerImpl
implements ProcessingLogger {
    private final Logger inner;
    private final ProcessingLogConfig config;

    public ProcessingLoggerImpl(ProcessingLogConfig config, Logger inner) {
        this.config = Objects.requireNonNull(config, "config");
        this.inner = Objects.requireNonNull(inner, "inner");
    }

    @Override
    public void error(ProcessingLogger.ErrorMessage msg) {
        this.inner.error((Object)new SerializableSchemaAndValue(ProcessingLoggerImpl.throwIfNotRightSchema(msg.get(this.config))));
    }

    @Override
    public void close() {
    }

    private static SchemaAndValue throwIfNotRightSchema(SchemaAndValue schemaAndValue) {
        if (!schemaAndValue.schema().equals(ProcessingLogMessageSchema.PROCESSING_LOG_SCHEMA)) {
            throw new RuntimeException("Received message with invalid schema");
        }
        return schemaAndValue;
    }
}

