/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logging.processing;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import io.confluent.common.logging.StructuredLogMessage;
import java.util.Map;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.json.JsonConverter;

final class SerializableSchemaAndValue
implements StructuredLogMessage {
    private static final JsonConverter converter = new JsonConverter();
    private final SchemaAndValue schemaAndValue;
    private volatile String asString = null;

    SerializableSchemaAndValue(SchemaAndValue schemaAndValue) {
        this.schemaAndValue = schemaAndValue;
    }

    public SchemaAndValue getMessage() {
        return this.schemaAndValue;
    }

    private String serializeToString() {
        byte[] bytes = converter.fromConnectData("", this.schemaAndValue.schema(), this.schemaAndValue.value());
        return new String(bytes, Charsets.UTF_8);
    }

    public String toString() {
        if (this.asString == null) {
            this.asString = this.serializeToString();
        }
        return this.asString;
    }

    static {
        converter.configure((Map)ImmutableMap.of((Object)"schemas.enable", (Object)false), false);
    }
}

