/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metrics;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="MetricAppender", category="Core", elementType="appender", printObject=true)
public class MetricAppender
extends AbstractAppender {
    private static final String KSQL_LOGGING_JMX_PREFIX = "io.confluent.ksql.metrics.logging";
    private static final String KSQL_LOGGING_METRIC_GROUP = "ksql-logging";
    private final Metrics metrics = new Metrics(new MetricConfig().samples(100).timeWindow(1L, TimeUnit.SECONDS), (List)ImmutableList.of((Object)new JmxReporter()), Time.SYSTEM, (MetricsContext)new KafkaMetricsContext("io.confluent.ksql.metrics.logging"));
    private final Sensor errors = this.metrics.sensor("ksql-logging-error-rate");
    private final Sensor warns;
    private final Sensor infos;

    protected MetricAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        this.errors.add(this.metrics.metricName("errors", KSQL_LOGGING_METRIC_GROUP, "number of error logs per second"), (MeasurableStat)new Rate());
        this.warns = this.metrics.sensor("ksql-logging-warn-rate");
        this.warns.add(this.metrics.metricName("warns", KSQL_LOGGING_METRIC_GROUP, "number of warn logs per second"), (MeasurableStat)new Rate());
        this.infos = this.metrics.sensor("ksql-logging-info-rate");
        this.infos.add(this.metrics.metricName("infos", KSQL_LOGGING_METRIC_GROUP, "number of info logs per second"), (MeasurableStat)new Rate());
    }

    @PluginFactory
    public static MetricAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions) {
        return new MetricAppender(name, filter, layout, ignoreExceptions);
    }

    public void append(LogEvent event) {
        if (event.getLevel() == Level.INFO) {
            this.infos.record();
        } else if (event.getLevel() == Level.WARN) {
            this.warns.record();
        } else if (event.getLevel() == Level.ERROR) {
            this.errors.record();
        }
    }
}

