/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.properties;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.confluent.ksql.util.KsqlException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DenyListPropertyValidator {
    private final Set<String> immutableProps;

    public DenyListPropertyValidator(Collection<String> immutableProps) {
        this.immutableProps = ImmutableSet.builder().addAll((Iterable)Objects.requireNonNull(immutableProps, "immutableProps")).add((Object)"ksql.service.id").build();
    }

    public void validateAll(Map<String, Object> properties) {
        Sets.SetView propsDenied = Sets.intersection(this.immutableProps, properties.keySet());
        if (!propsDenied.isEmpty()) {
            throw new KsqlException(String.format("One or more properties overrides set locally are prohibited by the KSQL server (use UNSET to reset their default value): %s", propsDenied));
        }
    }
}

