/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.oauth;

import io.confluent.ksql.security.AuthType;
import io.confluent.ksql.security.oauth.IdpConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigException;

public final class ClientSecretIdpConfig
implements IdpConfig {
    private String idpTokenEndpointUrl = "";
    private String idpClientId = "";
    private String idpClientSecret = "";
    private String idpScope = "";
    private String idpScopeClaimName = "scope";
    private String idpSubClaimName = "sub";
    private Short idpCacheExpiryBufferSeconds = 300;

    @Override
    public AuthType getAuthType() {
        return AuthType.OAUTHBEARER;
    }

    @Override
    public String getAuthenticationMethod() {
        return "CLIENT_SECRET";
    }

    @Override
    public Map<String, Object> toIdpCredentialsConfig() {
        HashMap<String, Object> idpCredentialsConfig = new HashMap<String, Object>();
        idpCredentialsConfig.put("bearer.auth.issuer.endpoint.url", this.idpTokenEndpointUrl);
        idpCredentialsConfig.put("bearer.auth.client.id", this.idpClientId);
        idpCredentialsConfig.put("bearer.auth.client.secret", this.idpClientSecret);
        idpCredentialsConfig.put("bearer.auth.scope", this.idpScope);
        idpCredentialsConfig.put("bearer.auth.scope.claim.name", this.idpScopeClaimName);
        idpCredentialsConfig.put("bearer.auth.sub.claim.name", this.idpSubClaimName);
        idpCredentialsConfig.put("bearer.auth.cache.expiry.buffer.seconds", this.idpCacheExpiryBufferSeconds);
        return idpCredentialsConfig;
    }

    public void configure(Map<String, ?> configs) {
        this.idpTokenEndpointUrl = (String)configs.get("bearer.auth.issuer.endpoint.url");
        this.idpClientId = (String)configs.get("bearer.auth.client.id");
        this.idpClientSecret = (String)configs.get("bearer.auth.client.secret");
        this.idpScope = (String)configs.get("bearer.auth.scope");
        if (configs.get("bearer.auth.scope.claim.name") != null) {
            this.idpScopeClaimName = (String)configs.get("bearer.auth.scope.claim.name");
        }
        if (configs.get("bearer.auth.sub.claim.name") != null) {
            this.idpSubClaimName = (String)configs.get("bearer.auth.sub.claim.name");
        }
        if (configs.get("bearer.auth.cache.expiry.buffer.seconds") != null) {
            this.idpCacheExpiryBufferSeconds = (Short)configs.get("bearer.auth.cache.expiry.buffer.seconds");
        }
        this.validate();
    }

    private void validate() throws ConfigException {
        if (this.isNullOrEmpty(this.idpTokenEndpointUrl)) {
            throw new ConfigException("Cannot configure OAuthBearer client credentials without token endpoint url");
        }
        if (this.isNullOrEmpty(this.idpClientId)) {
            throw new ConfigException("Cannot configure OAuthBearer client credentials without client ID");
        }
        if (this.isNullOrEmpty(this.idpClientSecret)) {
            throw new ConfigException("Cannot configure OAuthBearer client credentials without client Secret");
        }
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public String getIdpTokenEndpointUrl() {
        return this.idpTokenEndpointUrl;
    }

    public String getIdpClientId() {
        return this.idpClientId;
    }

    public String getIdpClientSecret() {
        return this.idpClientSecret;
    }

    public String getIdpScope() {
        return this.idpScope;
    }

    public String getIdpScopeClaimName() {
        return this.idpScopeClaimName;
    }

    public String getIdpSubClaimName() {
        return this.idpSubClaimName;
    }

    public Short getIdpCacheExpiryBufferSeconds() {
        return this.idpCacheExpiryBufferSeconds;
    }

    @Override
    public ClientSecretIdpConfig copy() {
        return new Builder().withTokenEndpointUrl(this.idpTokenEndpointUrl).withClientId(this.idpClientId).withClientSecret(this.idpClientSecret).withScope(this.idpScope).withScopeClaimName(this.idpScopeClaimName).withSubClaimName(this.idpSubClaimName).withCacheExpiryBufferSeconds(this.idpCacheExpiryBufferSeconds).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientSecretIdpConfig)) {
            return false;
        }
        ClientSecretIdpConfig clientSecretIdpConfig = (ClientSecretIdpConfig)o;
        return Objects.equals(this.idpTokenEndpointUrl, clientSecretIdpConfig.idpTokenEndpointUrl) && Objects.equals(this.idpClientId, clientSecretIdpConfig.idpClientId) && Objects.equals(this.idpClientSecret, clientSecretIdpConfig.idpClientSecret) && Objects.equals(this.idpScope, clientSecretIdpConfig.idpScope) && Objects.equals(this.idpScopeClaimName, clientSecretIdpConfig.idpScopeClaimName) && Objects.equals(this.idpSubClaimName, clientSecretIdpConfig.idpSubClaimName) && Objects.equals(this.idpCacheExpiryBufferSeconds, clientSecretIdpConfig.idpCacheExpiryBufferSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.idpTokenEndpointUrl, this.idpClientId, this.idpClientSecret, this.idpScope, this.idpScopeClaimName, this.idpSubClaimName, this.idpCacheExpiryBufferSeconds);
    }

    public String toString() {
        return "IdpConfig{idpTokenEndpointUrl='" + this.idpTokenEndpointUrl + "', idpClientId='" + this.idpClientId + "', idpClientSecret='" + this.idpClientSecret + "', idpScope='" + this.idpScope + "', idpScopeClaimName='" + this.idpScopeClaimName + "', idpSubClaimName='" + this.idpSubClaimName + "', idpCacheExpiryBufferSeconds=" + this.idpCacheExpiryBufferSeconds + "}";
    }

    public static class Builder {
        private final ClientSecretIdpConfig config = new ClientSecretIdpConfig();

        public Builder withTokenEndpointUrl(String url) {
            this.config.idpTokenEndpointUrl = url;
            return this;
        }

        public Builder withClientId(String clientId) {
            this.config.idpClientId = clientId;
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.config.idpClientSecret = clientSecret;
            return this;
        }

        public Builder withScope(String scope) {
            this.config.idpScope = scope;
            return this;
        }

        public Builder withScopeClaimName(String scopeClaimName) {
            this.config.idpScopeClaimName = scopeClaimName;
            return this;
        }

        public Builder withSubClaimName(String subClaimName) {
            this.config.idpSubClaimName = subClaimName;
            return this;
        }

        public Builder withCacheExpiryBufferSeconds(Short cacheExpiryBufferSeconds) {
            this.config.idpCacheExpiryBufferSeconds = cacheExpiryBufferSeconds;
            return this;
        }

        public ClientSecretIdpConfig build() {
            return this.config;
        }
    }
}

