/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.oauth;

import io.confluent.ksql.security.oauth.ClientSecretIdpConfig;
import io.confluent.ksql.security.oauth.IdpConfig;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdpConfigFactory {
    private static final Logger log = LoggerFactory.getLogger(IdpConfigFactory.class);

    private IdpConfigFactory() {
    }

    public static IdpConfig getIdpConfig(Map<String, ?> configs) {
        String bearerAuthMethod = (String)configs.get("bearer.auth.method");
        if (bearerAuthMethod == null || bearerAuthMethod.isEmpty()) {
            ClientSecretIdpConfig clientSecretIdpConfig = new ClientSecretIdpConfig();
            try {
                clientSecretIdpConfig.configure(configs);
                return clientSecretIdpConfig;
            }
            catch (ConfigException e) {
                log.info("Configuring client secret authentication method failed with {}", (Object)e.getMessage());
                return null;
            }
        }
        ServiceLoader<IdpConfig> serviceLoader = ServiceLoader.load(IdpConfig.class, IdpConfigFactory.class.getClassLoader());
        for (IdpConfig idpConfig : serviceLoader) {
            if (!idpConfig.getAuthenticationMethod().equals(bearerAuthMethod)) continue;
            idpConfig.configure(configs);
            return idpConfig;
        }
        return null;
    }
}

