/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.parser.OutputRefinement;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class WindowInfo {
    private final WindowType type;
    private final Optional<Duration> size;
    private final OutputRefinement emitStrategy;

    @JsonCreator
    public static WindowInfo of(@JsonProperty(value="type", required=true) WindowType type, @JsonProperty(value="size") Optional<Duration> size, @JsonProperty(value="emitStrategy") Optional<OutputRefinement> emitStrategy) {
        return new WindowInfo(type, size, emitStrategy);
    }

    private WindowInfo(WindowType type, Optional<Duration> size, Optional<OutputRefinement> emitStrategy) {
        this.type = Objects.requireNonNull(type, "type");
        this.size = Objects.requireNonNull(size, "size");
        this.emitStrategy = Objects.requireNonNull(emitStrategy.orElse(OutputRefinement.CHANGES), "emitStrategy");
        if (type.requiresWindowSize() && !size.isPresent()) {
            throw new IllegalArgumentException("Size required");
        }
        if (!type.requiresWindowSize() && size.isPresent()) {
            throw new IllegalArgumentException("Size not required");
        }
        if (size.isPresent() && (size.get().isZero() || size.get().isNegative())) {
            throw new IllegalArgumentException("Size must be positive");
        }
    }

    public WindowType getType() {
        return this.type;
    }

    public Optional<Duration> getSize() {
        return this.size;
    }

    public OutputRefinement getEmitStrategy() {
        return this.emitStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowInfo that = (WindowInfo)o;
        return this.type == that.type && Objects.equals(this.size, that.size);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.size});
    }

    public String toString() {
        return "WindowInfo{type=" + String.valueOf((Object)this.type) + ", size=" + String.valueOf(this.size.map(Duration::toMillis)) + ", emitStrategy=" + String.valueOf((Object)this.emitStrategy) + "}";
    }
}

