/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public final class HandlerMaps {
    private HandlerMaps() {
    }

    public static <K> Builder0<K> forClass(Class<K> type) {
        return new Builder0();
    }

    public static class Builder0<K> {
        private final Map<Class<? extends K>, Handler0<K>> handlers = Maps.newHashMap();

        public <A0> Builder1<K, A0> withArgType(Class<A0> arg0) {
            this.throwIfHandlers();
            return new Builder1();
        }

        public <A0, A1> Builder2<K, A0, A1> withArgTypes(Class<A0> arg0, Class<A1> arg1) {
            this.throwIfHandlers();
            return new Builder2();
        }

        public <KT extends K> Builder0<K> put(Class<KT> type, Supplier<? extends Handler0<? super KT>> supplier) {
            Handler0<? super KT> handler;
            try {
                handler = supplier.get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to get handler for type: " + String.valueOf(type), e);
            }
            if (handler == null) {
                throw new IllegalArgumentException("Null handler returned by supplier for type: " + String.valueOf(type));
            }
            return this.put(type, handler);
        }

        public <KT extends K> Builder0<K> put(Class<KT> type, Handler0<? super KT> handler) {
            if (this.handlers.containsKey(type)) {
                throw new IllegalArgumentException("Duplicate key: " + String.valueOf(type));
            }
            this.handlers.put(type, this.castHandler0(type, handler));
            return this;
        }

        public ClassHandlerMap0<K> build() {
            return new ClassHandlerMap0<K>(this.handlers);
        }

        private <KT extends K> Handler0<K> castHandler0(Class<KT> keyType, Handler0<? super KT> handler) {
            return k -> handler.handle((Object)keyType.cast(k));
        }

        private void throwIfHandlers() {
            if (!this.handlers.isEmpty()) {
                throw new IllegalStateException("handlers defined");
            }
        }
    }

    public static final class ClassHandlerMapR2<K, A0, A1, R> {
        private final Map<Class<? extends K>, HandlerR2<K, A0, A1, R>> handlers;

        private ClassHandlerMapR2(Map<Class<? extends K>, HandlerR2<K, A0, A1, R>> handlers) {
            this.handlers = ImmutableMap.copyOf(handlers);
        }

        public HandlerR2<K, A0, A1, R> get(Class<? extends K> type) {
            return this.handlers.get(type);
        }

        public <KT extends K> HandlerR2<KT, A0, A1, R> getTyped(Class<KT> type) {
            return this.handlers.get(type);
        }

        public HandlerR2<K, A0, A1, R> getOrDefault(Class<? extends K> type, HandlerR2<? super K, ? super A0, ? super A1, ? extends R> defaultHandler) {
            return this.handlers.getOrDefault(type, defaultHandler);
        }

        public Set<Class<? extends K>> keySet() {
            return this.handlers.keySet();
        }
    }

    public static final class BuilderR2<K, A0, A1, R> {
        private final Map<Class<? extends K>, HandlerR2<K, A0, A1, R>> handlers = Maps.newHashMap();

        public <KT extends K> BuilderR2<K, A0, A1, R> put0(Class<KT> type, Supplier<? extends HandlerR0<? super KT, ? extends R>> supplier) {
            HandlerR0<? super KT, ? extends R> handler;
            try {
                handler = supplier.get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to get handler for type: " + String.valueOf(type), e);
            }
            if (handler == null) {
                throw new IllegalArgumentException("Null handler returned by supplier for type: " + String.valueOf(type));
            }
            return this.put(type, handler);
        }

        public <KT extends K> BuilderR2<K, A0, A1, R> put1(Class<KT> type, Supplier<? extends HandlerR1<? super KT, ? super A0, ? extends R>> supplier) {
            HandlerR1<? super KT, ? super A0, ? extends R> handler;
            try {
                handler = supplier.get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to get handler for type: " + String.valueOf(type), e);
            }
            if (handler == null) {
                throw new IllegalArgumentException("Null handler returned by supplier for type: " + String.valueOf(type));
            }
            return this.put(type, handler);
        }

        public <KT extends K> BuilderR2<K, A0, A1, R> put(Class<KT> type, Supplier<? extends HandlerR2<? super KT, ? super A0, ? super A1, ? extends R>> supplier) {
            HandlerR2<? super KT, ? super A0, ? super A1, ? extends R> handler;
            try {
                handler = supplier.get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to get handler for type: " + String.valueOf(type), e);
            }
            if (handler == null) {
                throw new IllegalArgumentException("Null handler returned by supplier for type: " + String.valueOf(type));
            }
            return this.put(type, handler);
        }

        public <KT extends K> BuilderR2<K, A0, A1, R> put(Class<KT> type, HandlerR0<? super KT, ? extends R> handler) {
            if (this.handlers.containsKey(type)) {
                throw new IllegalArgumentException("Duplicate key: " + String.valueOf(type));
            }
            this.handlers.put(type, this.castHandler0(type, handler));
            return this;
        }

        public <KT extends K> BuilderR2<K, A0, A1, R> put(Class<KT> type, HandlerR1<? super KT, ? super A0, ? extends R> handler) {
            if (this.handlers.containsKey(type)) {
                throw new IllegalArgumentException("Duplicate key: " + String.valueOf(type));
            }
            this.handlers.put(type, this.castHandler1(type, handler));
            return this;
        }

        public <KT extends K> BuilderR2<K, A0, A1, R> put(Class<KT> type, HandlerR2<? super KT, ? super A0, ? super A1, ? extends R> handler) {
            if (this.handlers.containsKey(type)) {
                throw new IllegalArgumentException("Duplicate key: " + String.valueOf(type));
            }
            this.handlers.put(type, this.castHandler2(type, handler));
            return this;
        }

        public ClassHandlerMapR2<K, A0, A1, R> build() {
            return new ClassHandlerMapR2<K, A0, A1, R>(this.handlers);
        }

        private <KT extends K> HandlerR2<K, A0, A1, R> castHandler0(Class<KT> keyType, HandlerR0<? super KT, ? extends R> handler) {
            return (a0, a1, k) -> handler.handle((Object)keyType.cast(k));
        }

        private <KT extends K> HandlerR2<K, A0, A1, R> castHandler1(Class<KT> keyType, HandlerR1<? super KT, ? super A0, ? extends R> handler) {
            return (a0, a1, k) -> handler.handle((Object)a0, (Object)keyType.cast(k));
        }

        private <KT extends K> HandlerR2<K, A0, A1, R> castHandler2(Class<KT> keyType, HandlerR2<? super KT, ? super A0, ? super A1, ? extends R> handler) {
            return (a0, a1, k) -> handler.handle((Object)a0, (Object)a1, (Object)keyType.cast(k));
        }
    }

    public static final class ClassHandlerMap2<K, A0, A1> {
        private final Map<Class<? extends K>, Handler2<K, A0, A1>> handlers;

        private ClassHandlerMap2(Map<Class<? extends K>, Handler2<K, A0, A1>> handlers) {
            this.handlers = ImmutableMap.copyOf(handlers);
        }

        public Handler2<K, A0, A1> get(Class<? extends K> type) {
            return this.handlers.get(type);
        }

        public <KT extends K> Handler2<KT, A0, A1> getTyped(Class<KT> type) {
            return this.handlers.get(type);
        }

        public Handler2<K, A0, A1> getOrDefault(Class<? extends K> type, Handler2<? super K, ? super A0, ? super A1> defaultHandler) {
            return this.handlers.getOrDefault(type, defaultHandler);
        }

        public Set<Class<? extends K>> keySet() {
            return this.handlers.keySet();
        }
    }

    public static class Builder2<K, A0, A1> {
        private final Map<Class<? extends K>, Handler2<K, A0, A1>> handlers = Maps.newHashMap();

        public <R> BuilderR2<K, A0, A1, R> withReturnType(Class<R> returnType) {
            if (!this.handlers.isEmpty()) {
                throw new IllegalStateException("handlers already defined");
            }
            return new BuilderR2();
        }

        public <KT extends K> Builder2<K, A0, A1> put0(Class<KT> type, Supplier<? extends Handler0<? super KT>> supplier) {
            Handler0<? super KT> handler;
            try {
                handler = supplier.get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to get handler for type: " + String.valueOf(type), e);
            }
            if (handler == null) {
                throw new IllegalArgumentException("Null handler returned by supplier for type: " + String.valueOf(type));
            }
            return this.put(type, handler);
        }

        public <KT extends K> Builder2<K, A0, A1> put1(Class<KT> type, Supplier<? extends Handler1<? super KT, ? super A0>> supplier) {
            Handler1<? super KT, ? super A0> handler;
            try {
                handler = supplier.get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to get handler for type: " + String.valueOf(type), e);
            }
            if (handler == null) {
                throw new IllegalArgumentException("Null handler returned by supplier for type: " + String.valueOf(type));
            }
            return this.put(type, handler);
        }

        public <KT extends K> Builder2<K, A0, A1> put(Class<KT> type, Supplier<? extends Handler2<? super KT, ? super A0, ? super A1>> supplier) {
            Handler2<? super KT, ? super A0, ? super A1> handler;
            try {
                handler = supplier.get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to get handler for type: " + String.valueOf(type), e);
            }
            if (handler == null) {
                throw new IllegalArgumentException("Null handler returned by supplier for type: " + String.valueOf(type));
            }
            return this.put(type, handler);
        }

        public <KT extends K> Builder2<K, A0, A1> put(Class<KT> type, Handler0<? super KT> handler) {
            if (this.handlers.containsKey(type)) {
                throw new IllegalArgumentException("Duplicate key: " + String.valueOf(type));
            }
            this.handlers.put(type, this.castHandler0(type, handler));
            return this;
        }

        public <KT extends K> Builder2<K, A0, A1> put(Class<KT> type, Handler1<? super KT, ? super A0> handler) {
            if (this.handlers.containsKey(type)) {
                throw new IllegalArgumentException("Duplicate key: " + String.valueOf(type));
            }
            this.handlers.put(type, this.castHandler1(type, handler));
            return this;
        }

        public <KT extends K> Builder2<K, A0, A1> put(Class<KT> type, Handler2<? super KT, ? super A0, ? super A1> handler) {
            if (this.handlers.containsKey(type)) {
                throw new IllegalArgumentException("Duplicate key: " + String.valueOf(type));
            }
            this.handlers.put(type, this.castHandler2(type, handler));
            return this;
        }

        public ClassHandlerMap2<K, A0, A1> build() {
            return new ClassHandlerMap2<K, A0, A1>(this.handlers);
        }

        private <KT extends K> Handler2<K, A0, A1> castHandler0(Class<KT> keyType, Handler0<? super KT> handler) {
            return (a0, a1, k) -> handler.handle((Object)keyType.cast(k));
        }

        private <KT extends K> Handler2<K, A0, A1> castHandler1(Class<KT> keyType, Handler1<? super KT, ? super A0> handler) {
            return (a0, a1, k) -> handler.handle((Object)a0, (Object)keyType.cast(k));
        }

        private <KT extends K> Handler2<K, A0, A1> castHandler2(Class<KT> keyType, Handler2<? super KT, ? super A0, ? super A1> handler) {
            return (a0, a1, k) -> handler.handle((Object)a0, (Object)a1, (Object)keyType.cast(k));
        }
    }

    public static final class ClassHandlerMap1<K, A0> {
        private final Map<Class<? extends K>, Handler1<K, A0>> handlers;

        private ClassHandlerMap1(Map<Class<? extends K>, Handler1<K, A0>> handlers) {
            this.handlers = ImmutableMap.copyOf(handlers);
        }

        public Handler1<K, A0> get(Class<? extends K> type) {
            return this.handlers.get(type);
        }

        public <KT extends K> Handler1<KT, A0> getTyped(Class<KT> type) {
            return this.handlers.get(type);
        }

        public Handler1<K, A0> getOrDefault(Class<? extends K> type, Handler1<? super K, ? super A0> defaultHandler) {
            return this.handlers.getOrDefault(type, defaultHandler);
        }

        public Set<Class<? extends K>> keySet() {
            return this.handlers.keySet();
        }
    }

    public static class Builder1<K, A0> {
        private final Map<Class<? extends K>, Handler1<K, A0>> handlers = Maps.newHashMap();

        public <KT extends K> Builder1<K, A0> put0(Class<KT> type, Supplier<? extends Handler0<? super KT>> supplier) {
            Handler0<? super KT> handler;
            try {
                handler = supplier.get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to get handler for type: " + String.valueOf(type), e);
            }
            if (handler == null) {
                throw new IllegalArgumentException("Null handler returned by supplier for type: " + String.valueOf(type));
            }
            return this.put(type, handler);
        }

        public <KT extends K> Builder1<K, A0> put(Class<KT> type, Handler0<? super KT> handler) {
            if (this.handlers.containsKey(type)) {
                throw new IllegalArgumentException("Duplicate key: " + String.valueOf(type));
            }
            this.handlers.put(type, this.castHandler0(type, handler));
            return this;
        }

        public <KT extends K> Builder1<K, A0> put(Class<KT> type, Handler1<? super KT, ? super A0> handler) {
            if (this.handlers.containsKey(type)) {
                throw new IllegalArgumentException("Duplicate key: " + String.valueOf(type));
            }
            this.handlers.put(type, this.castHandler1(type, handler));
            return this;
        }

        public <KT extends K> Builder1<K, A0> put(Class<KT> type, Supplier<? extends Handler1<? super KT, ? super A0>> supplier) {
            Handler1<? super KT, ? super A0> handler;
            try {
                handler = supplier.get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to get handler for type: " + String.valueOf(type), e);
            }
            if (handler == null) {
                throw new IllegalArgumentException("Null handler returned by supplier for type: " + String.valueOf(type));
            }
            return this.put(type, handler);
        }

        public ClassHandlerMap1<K, A0> build() {
            return new ClassHandlerMap1<K, A0>(this.handlers);
        }

        private <KT extends K> Handler1<K, A0> castHandler0(Class<KT> keyType, Handler0<? super KT> handler) {
            return (a0, k) -> handler.handle((Object)keyType.cast(k));
        }

        private <KT extends K> Handler1<K, A0> castHandler1(Class<KT> keyType, Handler1<? super KT, ? super A0> handler) {
            return (a0, k) -> handler.handle((Object)a0, (Object)keyType.cast(k));
        }
    }

    public static final class ClassHandlerMap0<K> {
        private final Map<Class<? extends K>, Handler0<K>> handlers;

        private ClassHandlerMap0(Map<Class<? extends K>, Handler0<K>> handlers) {
            this.handlers = ImmutableMap.copyOf(handlers);
        }

        public Handler0<K> get(Class<? extends K> type) {
            return this.handlers.get(type);
        }

        public <KT extends K> Handler0<KT> getTyped(Class<KT> type) {
            return this.handlers.get(type);
        }

        public Handler0<K> getOrDefault(Class<? extends K> type, Handler0<? super K> defaultHandler) {
            return this.handlers.getOrDefault(type, defaultHandler);
        }

        public Set<Class<? extends K>> keySet() {
            return this.handlers.keySet();
        }
    }

    @FunctionalInterface
    public static interface HandlerR2<K, A0, A1, R> {
        public R handle(A0 var1, A1 var2, K var3);
    }

    @FunctionalInterface
    public static interface Handler2<K, A0, A1> {
        public void handle(A0 var1, A1 var2, K var3);
    }

    @FunctionalInterface
    public static interface HandlerR1<K, A0, R> {
        public R handle(A0 var1, K var2);
    }

    @FunctionalInterface
    public static interface Handler1<K, A0> {
        public void handle(A0 var1, K var2);
    }

    @FunctionalInterface
    public static interface HandlerR0<K, R> {
        public R handle(K var1);
    }

    @FunctionalInterface
    public static interface Handler0<K> {
        public void handle(K var1);
    }
}

