/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.util.Objects;

public class Triple<T1, T2, T3> {
    public final T1 left;
    public final T2 middle;
    public final T3 right;

    public static <L, M, R> Triple<L, M, R> of(L left, M middle, R right) {
        return new Triple<L, M, R>(left, middle, right);
    }

    public Triple(T1 left, T2 middle, T3 right) {
        this.left = left;
        this.middle = middle;
        this.right = right;
    }

    public T1 getLeft() {
        return this.left;
    }

    public T2 getMiddle() {
        return this.middle;
    }

    public T3 getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Triple triple = (Triple)o;
        return Objects.equals(this.left, triple.left) && Objects.equals(this.middle, triple.middle) && Objects.equals(this.right, triple.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.middle, this.right);
    }

    public String toString() {
        return "Triple{left=" + String.valueOf(this.left) + ", middle=" + String.valueOf(this.middle) + ", right=" + String.valueOf(this.right) + "}";
    }
}

