/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.ddl.commands;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.ValueFormat;
import java.util.Objects;

@Immutable
public class KsqlTopic {
    private final String kafkaTopicName;
    private final KeyFormat keyFormat;
    private final ValueFormat valueFormat;

    public KsqlTopic(String kafkaTopicName, KeyFormat keyFormat, ValueFormat valueFormat) {
        this.kafkaTopicName = Objects.requireNonNull(kafkaTopicName, "kafkaTopicName");
        this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
        this.valueFormat = Objects.requireNonNull(valueFormat, "valueFormat");
    }

    public KeyFormat getKeyFormat() {
        return this.keyFormat;
    }

    public ValueFormat getValueFormat() {
        return this.valueFormat;
    }

    public String getKafkaTopicName() {
        return this.kafkaTopicName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KsqlTopic ksqlTopic = (KsqlTopic)o;
        return Objects.equals(this.kafkaTopicName, ksqlTopic.kafkaTopicName) && Objects.equals(this.keyFormat, ksqlTopic.keyFormat) && Objects.equals(this.valueFormat, ksqlTopic.valueFormat);
    }

    public int hashCode() {
        return Objects.hash(this.kafkaTopicName, this.keyFormat, this.valueFormat);
    }

    public String toString() {
        return "KsqlTopic{kafkaTopicName='" + this.kafkaTopicName + '\'' + ", keyFormat=" + this.keyFormat + ", valueFormat=" + this.valueFormat + '}';
    }
}

