/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.schema.Operator;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class ArithmeticBinaryExpression
extends Expression {
    private final Operator operator;
    private final Expression left;
    private final Expression right;

    public ArithmeticBinaryExpression(Operator operator, Expression left, Expression right) {
        this(Optional.empty(), operator, left, right);
    }

    public ArithmeticBinaryExpression(Optional<NodeLocation> location, Operator operator, Expression left, Expression right) {
        super(location);
        this.operator = Objects.requireNonNull(operator, "operator");
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitArithmeticBinary(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ArithmeticBinaryExpression that = (ArithmeticBinaryExpression)((Object)o);
        return this.operator == that.operator && Objects.equals((Object)this.left, (Object)that.left) && Objects.equals((Object)this.right, (Object)that.right);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.left, this.right});
    }
}

