/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class CreateArrayExpression
extends Expression {
    private final ImmutableList<Expression> values;

    public CreateArrayExpression(Optional<NodeLocation> location, List<Expression> values) {
        super(location);
        this.values = ImmutableList.copyOf(values);
    }

    public CreateArrayExpression(List<Expression> values) {
        this(Optional.empty(), values);
    }

    public ImmutableList<Expression> getValues() {
        return this.values;
    }

    @Override
    protected <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitCreateArrayExpression(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CreateArrayExpression that = (CreateArrayExpression)((Object)o);
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }
}

