/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class NotExpression
extends Expression {
    private final Expression value;

    public NotExpression(Expression value) {
        this(Optional.empty(), value);
    }

    public NotExpression(Optional<NodeLocation> location, Expression value) {
        super(location);
        this.value = Objects.requireNonNull(value, "value");
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitNotExpression(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NotExpression that = (NotExpression)((Object)o);
        return Objects.equals((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

