/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.function;

import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.function.AggregateFunctionInitArguments;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class UdafUtil {
    private UdafUtil() {
    }

    public static KsqlAggregateFunction<?, ?, ?> resolveAggregateFunction(FunctionRegistry functionRegistry, FunctionCall functionCall, LogicalSchema schema) {
        try {
            ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(schema, functionRegistry);
            SqlType argumentType = expressionTypeManager.getExpressionSqlType(functionCall.getArguments().get(0));
            Expression arg = functionCall.getArguments().get(0);
            Optional possibleValueColumn = arg instanceof UnqualifiedColumnReferenceExp ? schema.findValueColumn(((UnqualifiedColumnReferenceExp)arg).getColumnName()) : schema.findValueColumn(ColumnName.of((String)arg.toString()));
            Column valueColumn = (Column)possibleValueColumn.orElseThrow(() -> new KsqlException("Could not find column for expression: " + (Object)((Object)arg)));
            AggregateFunctionInitArguments aggregateFunctionInitArguments = UdafUtil.createAggregateFunctionInitArgs(valueColumn.index(), functionCall);
            return functionRegistry.getAggregateFunction(functionCall.getName(), argumentType, aggregateFunctionInitArguments);
        }
        catch (Exception e) {
            throw new KsqlException("Failed to create aggregate function: " + (Object)((Object)functionCall), (Throwable)e);
        }
    }

    public static AggregateFunctionInitArguments createAggregateFunctionInitArgs(int udafIndex, FunctionCall functionCall) {
        List<Expression> args = functionCall.getArguments();
        ArrayList<Object> initArgs = new ArrayList<Object>(Math.max(0, args.size() - 1));
        for (int idx = 1; idx < args.size(); ++idx) {
            Expression param = args.get(idx);
            if (!(param instanceof Literal)) {
                throw new KsqlException("Parameter " + (idx + 1) + " passed to function " + functionCall.getName().text() + " must be a literal constant, but was expression: '" + (Object)((Object)param) + "'");
            }
            initArgs.add(((Literal)param).getValue());
        }
        return new AggregateFunctionInitArguments(udafIndex, initArgs);
    }
}

