/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.function;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.KsqlTableFunction;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.List;
import java.util.stream.Collectors;

public final class UdtfUtil {
    private UdtfUtil() {
    }

    public static KsqlTableFunction resolveTableFunction(FunctionRegistry functionRegistry, FunctionCall functionCall, LogicalSchema schema) {
        ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(schema, functionRegistry);
        List<Expression> functionArgs = functionCall.getArguments();
        ImmutableList argTypes = functionArgs.isEmpty() ? ImmutableList.of((Object)FunctionRegistry.DEFAULT_FUNCTION_ARG_SCHEMA) : functionArgs.stream().map(expressionTypeManager::getExpressionSqlType).collect(Collectors.toList());
        return functionRegistry.getTableFunction(functionCall.getName(), (List)argTypes);
    }
}

