/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.function.udaf;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.function.TableAggregationFunction;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.streams.kstream.Aggregator;

public class KudafUndoAggregator
implements Aggregator<Struct, GenericRow, GenericRow> {
    private final int nonAggColumnCount;
    private final List<TableAggregationFunction<?, ?, ?>> aggregateFunctions;
    private final int columnCount;

    public KudafUndoAggregator(int nonAggColumnCount, List<TableAggregationFunction<?, ?, ?>> aggregateFunctions) {
        this.nonAggColumnCount = nonAggColumnCount;
        this.aggregateFunctions = ImmutableList.copyOf((Collection)Objects.requireNonNull(aggregateFunctions, "aggregateFunctions"));
        this.columnCount = nonAggColumnCount + aggregateFunctions.size();
        if (aggregateFunctions.isEmpty()) {
            throw new IllegalArgumentException("Aggregator needs aggregate functions");
        }
        if (nonAggColumnCount < 0) {
            throw new IllegalArgumentException("negative nonAggColumnCount: " + nonAggColumnCount);
        }
    }

    public GenericRow apply(Struct k, GenericRow rowValue, GenericRow aggRowValue) {
        int idx;
        GenericRow result = GenericRow.fromList((List)aggRowValue.values());
        for (idx = 0; idx < this.nonAggColumnCount; ++idx) {
            result.set(idx, rowValue.get(idx));
        }
        for (idx = this.nonAggColumnCount; idx < this.columnCount; ++idx) {
            TableAggregationFunction<?, ?, ?> function = this.aggregateFunctions.get(idx - this.nonAggColumnCount);
            Object argument = rowValue.get(function.getArgIndexInValue());
            Object previous = result.get(idx);
            result.set(idx, function.undo(argument, previous));
        }
        return result;
    }
}

