/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KGroupedStreamHolder;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.kafka.connect.data.Struct;

@Immutable
public class StreamGroupByKey
implements ExecutionStep<KGroupedStreamHolder> {
    private static final ImmutableList<ExecutionStep.Property> MUST_MATCH = ImmutableList.of((Object)new ExecutionStep.Property("class", Object::getClass), (Object)new ExecutionStep.Property("properties", ExecutionStep::getProperties), (Object)new ExecutionStep.Property("internal formats", s -> ((StreamGroupByKey)s).internalFormats));
    private final ExecutionStepPropertiesV1 properties;
    private final ExecutionStep<KStreamHolder<Struct>> source;
    private final Formats internalFormats;

    public StreamGroupByKey(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<KStreamHolder<Struct>> source, @JsonProperty(value="internalFormats", required=true) Formats internalFormats) {
        this.properties = Objects.requireNonNull(props, "props");
        this.internalFormats = Objects.requireNonNull(internalFormats, "internalFormats");
        this.source = Objects.requireNonNull(source, "source");
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    public ExecutionStep<KStreamHolder<Struct>> getSource() {
        return this.source;
    }

    public Formats getInternalFormats() {
        return this.internalFormats;
    }

    @Override
    public KGroupedStreamHolder build(PlanBuilder builder) {
        return builder.visitStreamGroupByKey(this);
    }

    @Override
    public void validateUpgrade(@Nonnull ExecutionStep<?> to) {
        this.mustMatch(to, (List<ExecutionStep.Property>)MUST_MATCH);
        this.getSource().validateUpgrade(((StreamGroupByKey)to).source);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamGroupByKey that = (StreamGroupByKey)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.source, that.source) && Objects.equals(this.internalFormats, that.internalFormats);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.source, this.internalFormats);
    }
}

