/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.kafka.connect.data.Struct;

@Immutable
public class StreamSelectKeyV1
implements ExecutionStep<KStreamHolder<Struct>> {
    private static final ImmutableList<ExecutionStep.Property> MUST_MATCH = ImmutableList.of((Object)new ExecutionStep.Property("class", Object::getClass), (Object)new ExecutionStep.Property("properties", ExecutionStep::getProperties), (Object)new ExecutionStep.Property("keyExpression", s -> ((StreamSelectKeyV1)s).keyExpression));
    private final ExecutionStepPropertiesV1 properties;
    private final Expression keyExpression;
    @EffectivelyImmutable
    private final ExecutionStep<? extends KStreamHolder<?>> source;

    public StreamSelectKeyV1(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<? extends KStreamHolder<?>> source, @JsonProperty(value="keyExpression", required=true) Expression keyExpression) {
        this.properties = Objects.requireNonNull(props, "props");
        this.source = Objects.requireNonNull(source, "source");
        this.keyExpression = Objects.requireNonNull(keyExpression, "keyExpression");
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    public Expression getKeyExpression() {
        return this.keyExpression;
    }

    public ExecutionStep<? extends KStreamHolder<?>> getSource() {
        return this.source;
    }

    @Override
    public KStreamHolder<Struct> build(PlanBuilder builder) {
        return builder.visitStreamSelectKey(this);
    }

    @Override
    public void validateUpgrade(@Nonnull ExecutionStep<?> to) {
        this.mustMatch(to, (List<ExecutionStep.Property>)MUST_MATCH);
        this.getSource().validateUpgrade(((StreamSelectKeyV1)to).source);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamSelectKeyV1 that = (StreamSelectKeyV1)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.source, that.source) && Objects.equals((Object)this.keyExpression, (Object)that.keyExpression);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.properties, this.source, this.keyExpression});
    }
}

