/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.JoinType;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.name.ColumnName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class StreamTableJoin<K>
implements ExecutionStep<KStreamHolder<K>> {
    private final ExecutionStepPropertiesV1 properties;
    private final JoinType joinType;
    private final ColumnName keyColName;
    private final Formats internalFormats;
    private final ExecutionStep<KStreamHolder<K>> leftSource;
    private final ExecutionStep<KTableHolder<K>> rightSource;

    @JsonCreator
    @Deprecated
    private StreamTableJoin(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="joinType", required=true) JoinType joinType, @JsonProperty(value="keyName", defaultValue="ROWKEY") Optional<ColumnName> keyColName, @JsonProperty(value="internalFormats", required=true) Formats internalFormats, @JsonProperty(value="leftSource", required=true) ExecutionStep<KStreamHolder<K>> leftSource, @JsonProperty(value="rightSource", required=true) ExecutionStep<KTableHolder<K>> rightSource) {
        this(props, joinType, keyColName.orElse(ColumnName.of((String)"ROWKEY")), internalFormats, leftSource, rightSource);
    }

    public StreamTableJoin(ExecutionStepPropertiesV1 props, JoinType joinType, ColumnName keyColName, Formats internalFormats, ExecutionStep<KStreamHolder<K>> leftSource, ExecutionStep<KTableHolder<K>> rightSource) {
        this.properties = Objects.requireNonNull(props, "props");
        this.internalFormats = Objects.requireNonNull(internalFormats, "internalFormats");
        this.joinType = Objects.requireNonNull(joinType, "joinType");
        this.keyColName = Objects.requireNonNull(keyColName, "keyColName");
        this.leftSource = Objects.requireNonNull(leftSource, "leftSource");
        this.rightSource = Objects.requireNonNull(rightSource, "rightSource");
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return ImmutableList.of(this.leftSource, this.rightSource);
    }

    public Formats getInternalFormats() {
        return this.internalFormats;
    }

    public ExecutionStep<KStreamHolder<K>> getLeftSource() {
        return this.leftSource;
    }

    public ExecutionStep<KTableHolder<K>> getRightSource() {
        return this.rightSource;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public ColumnName getKeyColName() {
        return this.keyColName;
    }

    @Override
    public KStreamHolder<K> build(PlanBuilder builder) {
        return builder.visitStreamTableJoin(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamTableJoin that = (StreamTableJoin)o;
        return Objects.equals(this.properties, that.properties) && this.joinType == that.joinType && Objects.equals(this.keyColName, that.keyColName) && Objects.equals(this.internalFormats, that.internalFormats) && Objects.equals(this.leftSource, that.leftSource) && Objects.equals(this.rightSource, that.rightSource);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.properties, this.joinType, this.keyColName, this.internalFormats, this.leftSource, this.rightSource});
    }
}

