/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.SourceStep;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.kafka.connect.data.Struct;

@Immutable
public final class TableSource
extends SourceStep<KTableHolder<Struct>> {
    private final Boolean forceChangelog;
    private static final ImmutableList<ExecutionStep.Property> MUST_MATCH = ImmutableList.of((Object)new ExecutionStep.Property("class", Object::getClass), (Object)new ExecutionStep.Property("properties", ExecutionStep::getProperties), (Object)new ExecutionStep.Property("topicName", s -> ((TableSource)s).topicName), (Object)new ExecutionStep.Property("formats", s -> ((TableSource)s).formats), (Object)new ExecutionStep.Property("timestampColumn", s -> ((TableSource)s).timestampColumn), (Object)new ExecutionStep.Property("forceChangelog", s -> ((TableSource)s).forceChangelog));

    public TableSource(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 properties, @JsonProperty(value="topicName", required=true) String topicName, @JsonProperty(value="formats", required=true) Formats formats, @JsonProperty(value="timestampColumn") Optional<TimestampColumn> timestampColumn, @JsonProperty(value="sourceSchema", required=true) LogicalSchema sourceSchema, @JsonProperty(value="forceChangelog") Optional<Boolean> forceChangelog) {
        super(properties, topicName, formats, timestampColumn, sourceSchema);
        this.forceChangelog = forceChangelog.orElse(false);
    }

    public Boolean isForceChangelog() {
        return this.forceChangelog;
    }

    @Override
    public KTableHolder<Struct> build(PlanBuilder builder) {
        return builder.visitTableSource(this);
    }

    @Override
    public void validateUpgrade(@Nonnull ExecutionStep<?> to) {
        ExecutionStep<?> source = to;
        while (!(source instanceof TableSource)) {
            if (to.getSources().isEmpty()) {
                throw new KsqlException("Query is not upgradeable. The root source node of the upgrade tree must be TableSource, but was " + source.getClass());
            }
            if (to.getSources().size() > 1) {
                throw new KsqlException("Query is not upgradeable. Cannot change a non-join source into a join source.");
            }
            if (to.type() != ExecutionStep.StepType.PASSIVE) {
                throw new KsqlException("Query is not upgradeable. Cannot add a " + to.getClass() + " step that is not in the original query plan.");
            }
            source = to.getSources().get(0);
        }
        this.mustMatch(source, (List<ExecutionStep.Property>)MUST_MATCH);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSource that = (TableSource)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.topicName, that.topicName) && Objects.equals(this.formats, that.formats) && Objects.equals(this.timestampColumn, that.timestampColumn) && Objects.equals(this.sourceSchema, that.sourceSchema) && Objects.equals(this.forceChangelog, that.forceChangelog);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.topicName, this.formats, this.timestampColumn, this.sourceSchema, this.forceChangelog);
    }
}

