/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.JoinType;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.name.ColumnName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class TableTableJoin<K>
implements ExecutionStep<KTableHolder<K>> {
    private final ExecutionStepPropertiesV1 properties;
    private final JoinType joinType;
    private final ColumnName keyColName;
    private final ExecutionStep<KTableHolder<K>> leftSource;
    private final ExecutionStep<KTableHolder<K>> rightSource;

    @JsonCreator
    @Deprecated
    private TableTableJoin(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="joinType", required=true) JoinType joinType, @JsonProperty(value="keyName", defaultValue="ROWKEY") Optional<ColumnName> keyColName, @JsonProperty(value="leftSource", required=true) ExecutionStep<KTableHolder<K>> leftSource, @JsonProperty(value="rightSource", required=true) ExecutionStep<KTableHolder<K>> rightSource) {
        this(props, joinType, keyColName.orElse(ColumnName.of((String)"ROWKEY")), leftSource, rightSource);
    }

    public TableTableJoin(ExecutionStepPropertiesV1 props, JoinType joinType, ColumnName keyColName, ExecutionStep<KTableHolder<K>> leftSource, ExecutionStep<KTableHolder<K>> rightSource) {
        this.properties = Objects.requireNonNull(props, "props");
        this.joinType = Objects.requireNonNull(joinType, "joinType");
        this.keyColName = Objects.requireNonNull(keyColName, "keyColName");
        this.leftSource = Objects.requireNonNull(leftSource, "leftSource");
        this.rightSource = Objects.requireNonNull(rightSource, "rightSource");
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return ImmutableList.of(this.leftSource, this.rightSource);
    }

    public ExecutionStep<KTableHolder<K>> getLeftSource() {
        return this.leftSource;
    }

    public ExecutionStep<KTableHolder<K>> getRightSource() {
        return this.rightSource;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public ColumnName getKeyColName() {
        return this.keyColName;
    }

    @Override
    public KTableHolder<K> build(PlanBuilder builder) {
        return builder.visitTableTableJoin(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableTableJoin that = (TableTableJoin)o;
        return Objects.equals(this.properties, that.properties) && this.joinType == that.joinType && Objects.equals(this.keyColName, that.keyColName) && Objects.equals(this.leftSource, that.leftSource) && Objects.equals(this.rightSource, that.rightSource);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.properties, this.joinType, this.keyColName, this.leftSource, this.rightSource});
    }
}

