/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.SourceStep;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.WindowInfo;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.streams.kstream.Windowed;

public final class WindowedTableSource
extends SourceStep<KTableHolder<Windowed<Struct>>> {
    private final WindowInfo windowInfo;

    public WindowedTableSource(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="topicName", required=true) String topicName, @JsonProperty(value="formats", required=true) Formats formats, @JsonProperty(value="windowInfo", required=true) WindowInfo windowInfo, @JsonProperty(value="timestampColumn") Optional<TimestampColumn> timestampColumn, @JsonProperty(value="sourceSchema", required=true) LogicalSchema sourceSchema) {
        super(props, topicName, formats, timestampColumn, sourceSchema);
        this.windowInfo = Objects.requireNonNull(windowInfo, "windowInfo");
    }

    public WindowInfo getWindowInfo() {
        return this.windowInfo;
    }

    @Override
    public KTableHolder<Windowed<Struct>> build(PlanBuilder builder) {
        return builder.visitWindowedTableSource(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowedTableSource that = (WindowedTableSource)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.topicName, that.topicName) && Objects.equals(this.formats, that.formats) && Objects.equals(this.timestampColumn, that.timestampColumn) && Objects.equals(this.sourceSchema, that.sourceSchema);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.topicName, this.formats, this.timestampColumn, this.sourceSchema);
    }
}

