/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.transform.select;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.ExpressionMetadata;
import io.confluent.ksql.execution.transform.KsqlProcessingContext;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.utils.FormatOptions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class SelectValueMapper<K> {
    private final ImmutableList<SelectInfo> selects;

    SelectValueMapper(List<SelectInfo> selects) {
        this.selects = ImmutableList.copyOf((Collection)Objects.requireNonNull(selects, "selects"));
    }

    List<SelectInfo> getSelects() {
        return this.selects;
    }

    public KsqlTransformer<K, GenericRow> getTransformer(ProcessingLogger processingLogger) {
        return new SelectMapper(this.selects, processingLogger);
    }

    private static final class SelectMapper<K>
    implements KsqlTransformer<K, GenericRow> {
        private final ImmutableList<SelectInfo> selects;
        private final ProcessingLogger processingLogger;

        private SelectMapper(ImmutableList<SelectInfo> selects, ProcessingLogger processingLogger) {
            this.selects = Objects.requireNonNull(selects, "selects");
            this.processingLogger = Objects.requireNonNull(processingLogger, "processingLogger");
        }

        @Override
        public GenericRow transform(K readOnlyKey, GenericRow value, KsqlProcessingContext ctx) {
            if (value == null) {
                return null;
            }
            GenericRow row = new GenericRow(this.selects.size());
            for (int i = 0; i < this.selects.size(); ++i) {
                row.append(this.processColumn(i, value));
            }
            return row;
        }

        private Object processColumn(int column, GenericRow row) {
            SelectInfo select = (SelectInfo)this.selects.get(column);
            Supplier<String> errorMsgSupplier = () -> "Error computing expression " + (Object)((Object)select.evaluator.getExpression()) + " for column " + select.fieldName.toString(FormatOptions.noEscape()) + " with index " + column;
            return select.evaluator.evaluate(row, null, this.processingLogger, errorMsgSupplier);
        }
    }

    public static final class SelectInfo {
        final ColumnName fieldName;
        final ExpressionMetadata evaluator;

        static SelectInfo of(ColumnName fieldName, ExpressionMetadata evaluator) {
            return new SelectInfo(fieldName, evaluator);
        }

        private SelectInfo(ColumnName fieldName, ExpressionMetadata evaluator) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
            this.evaluator = Objects.requireNonNull(evaluator, "evaluator");
        }

        public ColumnName getFieldName() {
            return this.fieldName;
        }

        ExpressionMetadata getEvaluator() {
            return this.evaluator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SelectInfo that = (SelectInfo)o;
            return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.evaluator, that.evaluator);
        }

        public int hashCode() {
            return Objects.hash(this.fieldName, this.evaluator);
        }
    }
}

