/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.util;

import com.google.common.collect.Iterables;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public final class StructKeyUtil {
    private StructKeyUtil() {
    }

    public static KeyBuilder keyBuilder(LogicalSchema schema) {
        List keyCols = schema.key();
        if (keyCols.size() != 1) {
            throw new UnsupportedOperationException("Only single keys supported");
        }
        Column keyCol = (Column)keyCols.get(0);
        return StructKeyUtil.keyBuilder(keyCol.name(), keyCol.type());
    }

    public static KeyBuilder keyBuilder(ColumnName name, SqlType type) {
        Schema connectSchema = SchemaConverters.sqlToConnectConverter().toConnectSchema(type);
        return new KeyBuilder(SchemaBuilder.struct().field(name.text(), connectSchema).build());
    }

    public static final class KeyBuilder {
        private final Schema keySchema;
        private final Field keyField;

        private KeyBuilder(Schema keySchema) {
            this.keySchema = Objects.requireNonNull(keySchema, "keySchema");
            this.keyField = (Field)Iterables.getOnlyElement((Iterable)keySchema.fields());
        }

        public Struct build(Object keyValue) {
            Struct keyStruct = new Struct(this.keySchema);
            keyStruct.put(this.keyField, keyValue);
            return keyStruct;
        }
    }
}

