/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.windows;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.execution.windows.WindowTimeClause;
import io.confluent.ksql.execution.windows.WindowVisitor;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.serde.WindowInfo;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class SessionWindowExpression
extends KsqlWindowExpression {
    private final WindowTimeClause gap;

    public SessionWindowExpression(WindowTimeClause gap) {
        this(Optional.empty(), gap, Optional.empty(), Optional.empty());
    }

    public SessionWindowExpression(Optional<NodeLocation> location, WindowTimeClause gap, Optional<WindowTimeClause> retention, Optional<WindowTimeClause> gracePeriod) {
        super(location, retention, gracePeriod);
        this.gap = Objects.requireNonNull(gap, "gap");
    }

    public WindowTimeClause getGap() {
        return this.gap;
    }

    @Override
    public WindowInfo getWindowInfo() {
        return WindowInfo.of((WindowType)WindowType.SESSION, Optional.empty());
    }

    @Override
    public <R, C> R accept(WindowVisitor<R, C> visitor, C context) {
        return visitor.visitSessionWindowExpression(this, context);
    }

    public String toString() {
        return " SESSION ( " + this.gap + this.retention.map(w -> " , RETENTION " + w).orElse("") + this.gracePeriod.map(g -> " , GRACE PERIOD " + g).orElse("") + " ) ";
    }

    public int hashCode() {
        return Objects.hash(this.gap, this.retention, this.gracePeriod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SessionWindowExpression sessionWindowExpression = (SessionWindowExpression)((Object)o);
        return Objects.equals(this.gap, sessionWindowExpression.gap) && Objects.equals(this.gracePeriod, sessionWindowExpression.gracePeriod) && Objects.equals(this.retention, sessionWindowExpression.retention);
    }
}

