/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.windows;

import com.google.errorprone.annotations.Immutable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Immutable
public class WindowTimeClause {
    private final long value;
    private final TimeUnit unit;

    public WindowTimeClause(long value, TimeUnit unit) {
        this.value = value;
        this.unit = Objects.requireNonNull(unit, "unit");
    }

    public Duration toDuration() {
        return Duration.ofMillis(this.unit.toMillis(this.value));
    }

    public String toString() {
        return this.value + " " + (Object)((Object)this.unit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.unit});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowTimeClause otherClause = (WindowTimeClause)o;
        return otherClause.value == this.value && otherClause.unit == this.unit;
    }
}

