/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public interface KafkaConsumerGroupClient {
    public List<String> listGroups();

    public ConsumerGroupSummary describeConsumerGroup(String var1);

    public Map<TopicPartition, OffsetAndMetadata> listConsumerGroupOffsets(String var1);

    public void deleteConsumerGroups(Set<String> var1);

    public static class ConsumerSummary {
        final List<TopicPartition> partitions = new ArrayList<TopicPartition>();
        private final String consumerId;

        public ConsumerSummary(String consumerId) {
            this.consumerId = consumerId;
        }

        public void addPartition(TopicPartition topicPartition) {
            this.partitions.add(topicPartition);
        }

        public List<TopicPartition> partitions() {
            return this.partitions;
        }

        public void addPartitions(Set<TopicPartition> topicPartitions) {
            this.partitions.addAll(topicPartitions);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsumerSummary that = (ConsumerSummary)o;
            return Objects.equals(this.consumerId, that.consumerId);
        }

        public int hashCode() {
            return Objects.hash(this.consumerId);
        }
    }

    public static class ConsumerGroupSummary {
        final Set<ConsumerSummary> consumerSummaries = new HashSet<ConsumerSummary>();

        public ConsumerGroupSummary(Set<ConsumerSummary> summaries) {
            this.consumerSummaries.addAll(summaries);
        }

        public Collection<ConsumerSummary> consumers() {
            return this.consumerSummaries;
        }
    }
}

