/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest;

import io.confluent.ksql.util.KsqlHostInfo;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class SessionProperties {
    private final Map<String, Object> mutableScopedProperties;
    private final KsqlHostInfo ksqlHostInfo;
    private final URL localUrl;
    private final boolean internalRequest;
    private final Map<String, String> sessionVariables;

    public SessionProperties(Map<String, Object> mutableScopedProperties, KsqlHostInfo ksqlHostInfo, URL localUrl, boolean internalRequest) {
        this.mutableScopedProperties = new HashMap<String, Object>(Objects.requireNonNull(mutableScopedProperties, "mutableScopedProperties"));
        this.ksqlHostInfo = Objects.requireNonNull(ksqlHostInfo, "ksqlHostInfo");
        this.localUrl = Objects.requireNonNull(localUrl, "localUrl");
        this.internalRequest = internalRequest;
        this.sessionVariables = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    }

    public Map<String, Object> getMutableScopedProperties() {
        return this.mutableScopedProperties;
    }

    public KsqlHostInfo getKsqlHostInfo() {
        return this.ksqlHostInfo;
    }

    public URL getLocalUrl() {
        return this.localUrl;
    }

    public boolean getInternalRequest() {
        return this.internalRequest;
    }

    public Map<String, String> getSessionVariables() {
        return Collections.unmodifiableMap(this.sessionVariables);
    }

    public void setVariable(String name, String value) {
        this.sessionVariables.put(name, value);
    }

    public void unsetVariable(String name) {
        this.sessionVariables.remove(name);
    }
}

